/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.schema;

import java.io.IOException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.graphql.api.SchemaProvider;
import org.apache.sling.servlethelpers.internalrequests.InternalRequest;
import org.apache.sling.servlethelpers.internalrequests.ServletInternalRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SchemaProvider.class}, immediate=true, property={"service.ranking:Integer=-2147482648", "service.description=Apache Sling Scripting GraphQL SchemaProvider", "service.vendor=The Apache Software Foundation"})
public class DefaultSchemaProvider
implements SchemaProvider {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public static final int SERVICE_RANKING = -2147482648;
    public static final String SCHEMA_EXTENSION = "GQLschema";
    public static final String DEFAULT_SCHEMA = "";
    @Reference
    private ServletResolver servletResolver;

    @Override
    public String getSchema(Resource r, String[] selectors) throws IOException {
        InternalRequest req = new ServletInternalRequest(this.servletResolver, r).withSelectors(selectors).withExtension(SCHEMA_EXTENSION);
        this.LOGGER.debug("Getting GraphQL Schema for {}: {}", (Object)r.getPath(), (Object)req);
        if (req.execute().getStatus() == 200) {
            return req.getResponseAsString();
        }
        return DEFAULT_SCHEMA;
    }
}

