/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.engine;

import graphql.language.Selection;
import graphql.schema.DataFetchingFieldSelectionSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.graphql.api.SelectedField;
import org.apache.sling.graphql.api.SelectionSet;
import org.apache.sling.graphql.core.engine.SelectedFieldWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionSetWrapper
implements SelectionSet {
    private List<SelectedField> fields = new ArrayList<SelectedField>();
    private Map<String, SelectedField> fieldsMap = new HashMap<String, SelectedField>();

    public SelectionSetWrapper(@Nullable DataFetchingFieldSelectionSet selectionSet) {
        if (selectionSet != null) {
            selectionSet.get().getSubFields().forEach((k, v) -> {
                SelectedFieldWrapper selectedField = new SelectedFieldWrapper((Selection)v.getSingleField());
                this.fieldsMap.put((String)k, selectedField);
                if (!k.contains("/")) {
                    this.fields.add(selectedField);
                }
            });
            this.initFlatMap(this.fields, "");
        }
    }

    private void initFlatMap(List<SelectedField> parentList, String qualifiedPath) {
        parentList.forEach(s -> {
            String qualifiedName = qualifiedPath + s.getName();
            if (!this.fieldsMap.containsKey(qualifiedName)) {
                this.fieldsMap.put(qualifiedName, (SelectedField)s);
            }
            this.initFlatMap(s.getSubSelectedFields(), qualifiedName + "/");
        });
    }

    @Override
    @NotNull
    public List<SelectedField> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public boolean contains(String qualifiedName) {
        return this.fieldsMap.containsKey(qualifiedName);
    }

    @Override
    public SelectedField get(String qualifiedName) {
        return this.fieldsMap.get(qualifiedName);
    }
}

