/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core;

import com.googlecode.pngtastic.core.PngChunk;
import com.googlecode.pngtastic.core.PngFilterType;
import com.googlecode.pngtastic.core.PngImage;
import com.googlecode.pngtastic.core.PngProcessor;
import com.googlecode.pngtastic.core.processing.PngByteArrayOutputStream;
import com.googlecode.pngtastic.core.processing.ZopfliCompressionHandler;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PngOptimizer
extends PngProcessor {
    private boolean generateDataUriCss = false;
    private final List<OptimizerResult> results = new ArrayList<OptimizerResult>();

    public void setGenerateDataUriCss(boolean generateDataUriCss) {
        this.generateDataUriCss = generateDataUriCss;
    }

    public List<OptimizerResult> getResults() {
        return this.results;
    }

    public PngOptimizer() {
        this("NONE");
    }

    public PngOptimizer(String logLevel) {
        super(logLevel);
    }

    public void optimize(PngImage image, String outputFileName, boolean removeGamma, Integer compressionLevel) throws IOException {
        this.log.debug("=== OPTIMIZING ===", new Object[0]);
        long start = System.currentTimeMillis();
        PngImage optimized = this.optimize(image, removeGamma, compressionLevel);
        ByteArrayOutputStream optimizedBytes = new ByteArrayOutputStream();
        long optimizedSize = optimized.writeDataOutputStream(optimizedBytes).size();
        File originalFile = new File(image.getFileName());
        long originalFileSize = originalFile.length();
        byte[] optimalBytes = optimizedSize < originalFileSize ? optimizedBytes.toByteArray() : this.getFileBytes(originalFile, originalFileSize);
        File exported = optimized.export(outputFileName, optimalBytes);
        long optimizedFileSize = exported.length();
        long time = System.currentTimeMillis() - start;
        this.log.debug("Optimized in %d milliseconds, size %d", time, optimizedSize);
        this.log.debug("Original length in bytes: %d (%s)", originalFileSize, image.getFileName());
        this.log.debug("Final length in bytes: %d (%s)", optimizedFileSize, outputFileName);
        long fileSizeDifference = optimizedFileSize <= originalFileSize ? originalFileSize - optimizedFileSize : -(optimizedFileSize - originalFileSize);
        this.log.info("%5.2f%% :%6dB ->%6dB (%5dB saved) - %s", Float.valueOf((float)fileSizeDifference / Float.valueOf(originalFileSize).floatValue() * 100.0f), originalFileSize, optimizedFileSize, fileSizeDifference, outputFileName);
        String dataUri = this.generateDataUriCss ? this.pngCompressionHandler.encodeBytes(optimalBytes) : null;
        this.results.add(new OptimizerResult(image.getFileName(), originalFileSize, optimizedFileSize, image.getWidth(), image.getHeight(), dataUri));
    }

    public PngImage optimize(PngImage image) throws IOException {
        return this.optimize(image, false, null);
    }

    public PngImage optimize(PngImage image, boolean removeGamma, Integer compressionLevel) throws IOException {
        if (image.getInterlace() == 1 && image.getSampleBitCount() < 8) {
            return image;
        }
        PngImage result = new PngImage(this.log);
        result.setInterlace((short)0);
        Iterator<PngChunk> itChunks = image.getChunks().iterator();
        PngChunk chunk = this.processHeadChunks(result, removeGamma, itChunks);
        PngByteArrayOutputStream inflatedImageData = this.getInflatedImageData(chunk, itChunks);
        int scanlineLength = (int)Math.ceil((float)(image.getWidth() * (long)image.getSampleBitCount()) / 8.0f) + 1;
        List<byte[]> originalScanlines = image.getInterlace() == 1 ? this.pngInterlaceHandler.deInterlace((int)image.getWidth(), (int)image.getHeight(), image.getSampleBitCount(), inflatedImageData) : this.getScanlines(inflatedImageData, image.getSampleBitCount(), scanlineLength, image.getHeight());
        HashMap<PngFilterType, List<byte[]>> filteredScanlines = new HashMap<PngFilterType, List<byte[]>>();
        for (PngFilterType filterType : PngFilterType.standardValues()) {
            this.log.debug("Applying filter: %s", new Object[]{filterType});
            List<byte[]> scanlines = this.copyScanlines(originalScanlines);
            this.pngFilterHandler.applyFiltering(filterType, scanlines, image.getSampleBitCount());
            filteredScanlines.put(filterType, scanlines);
        }
        PngFilterType bestFilterType = null;
        byte[] deflatedImageData = null;
        for (Map.Entry entry : filteredScanlines.entrySet()) {
            byte[] imageResult = this.pngCompressionHandler.deflate(this.serialize((List)entry.getValue()), compressionLevel, true);
            if (deflatedImageData != null && imageResult.length >= deflatedImageData.length) continue;
            deflatedImageData = imageResult;
            bestFilterType = (PngFilterType)((Object)entry.getKey());
        }
        List<byte[]> scanlines = this.copyScanlines(originalScanlines);
        this.pngFilterHandler.applyAdaptiveFiltering(inflatedImageData, scanlines, filteredScanlines, image.getSampleBitCount());
        byte[] adaptiveImageData = this.pngCompressionHandler.deflate(inflatedImageData, compressionLevel, true);
        this.log.debug("Original=%d, Adaptive=%d, %s=%d", new Object[]{image.getImageData().length, adaptiveImageData.length, bestFilterType, deflatedImageData == null ? 0 : deflatedImageData.length});
        if (deflatedImageData == null || adaptiveImageData.length < deflatedImageData.length) {
            deflatedImageData = adaptiveImageData;
            bestFilterType = PngFilterType.ADAPTIVE;
        }
        PngChunk imageChunk = new PngChunk("IDAT".getBytes(), deflatedImageData);
        result.addChunk(imageChunk);
        while (chunk != null) {
            if (chunk.isCritical() && !"IDAT".equals(chunk.getTypeString())) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream(chunk.getLength());
                DataOutputStream data = new DataOutputStream(bytes);
                data.write(chunk.getData());
                data.close();
                PngChunk newChunk = new PngChunk(chunk.getType(), bytes.toByteArray());
                result.addChunk(newChunk);
            }
            chunk = itChunks.hasNext() ? itChunks.next() : null;
        }
        List<PngChunk> chunks = result.getChunks();
        if (chunks != null && !"IEND".equals(chunks.get(chunks.size() - 1).getTypeString())) {
            result.addChunk(new PngChunk("IEND".getBytes(), new byte[0]));
        }
        return result;
    }

    private List<byte[]> copyScanlines(List<byte[]> original) {
        ArrayList<byte[]> copy = new ArrayList<byte[]>(original.size());
        for (byte[] scanline : original) {
            copy.add((byte[])scanline.clone());
        }
        return copy;
    }

    private PngByteArrayOutputStream serialize(List<byte[]> scanlines) {
        int scanlineLength = scanlines.get(0).length;
        byte[] imageData = new byte[scanlineLength * scanlines.size()];
        for (int i = 0; i < scanlines.size(); ++i) {
            int offset = i * scanlineLength;
            byte[] scanline = scanlines.get(i);
            System.arraycopy(scanline, 0, imageData, offset, scanlineLength);
        }
        return new PngByteArrayOutputStream(imageData);
    }

    public long getTotalSavings() {
        long totalSavings = 0L;
        for (OptimizerResult result : this.results) {
            totalSavings += result.getOriginalFileSize() - result.getOptimizedFileSize();
        }
        return totalSavings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDataUriCss(String dir) throws IOException {
        String path = dir == null ? "" : dir + "/";
        try (PrintWriter out = new PrintWriter(path + "DataUriCss.html");){
            String name;
            out.append("<html>\n<head>\n\t<style>");
            for (OptimizerResult result : this.results) {
                name = result.fileName.replaceAll("[^A-Za-z0-9]", "_");
                out.append('#').append(name).append(" {\n").append("\tbackground: url(\"data:image/png;base64,").append(result.dataUri).append("\") no-repeat left top;\n").append("\twidth: ").append(String.valueOf(result.width)).append("px;\n").append("\theight: ").append(String.valueOf(result.height)).append("px;\n").append("}\n");
            }
            out.append("\t</style>\n</head>\n<body>\n");
            for (OptimizerResult result : this.results) {
                name = result.fileName.replaceAll("[^A-Za-z0-9]", "_");
                out.append("\t<div id=\"").append(name).append("\"></div>\n");
            }
            out.append("</body>\n</html>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getFileBytes(File originalFile, long originalFileSize) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate((int)originalFileSize);
        try (FileInputStream ins = null;){
            ins = new FileInputStream(originalFile);
            ins.getChannel().read(buffer);
        }
        return buffer.array();
    }

    private void printData(byte[] inflatedImageData) {
        StringBuilder result = new StringBuilder();
        for (byte b : inflatedImageData) {
            result.append(String.format("%2x|", b));
        }
        this.log.debug(result.toString(), new Object[0]);
    }

    public void setCompressor(String compressor, Integer iterations) {
        if ("zopfli".equals(compressor)) {
            this.pngCompressionHandler = iterations != null ? new ZopfliCompressionHandler(this.log, iterations) : new ZopfliCompressionHandler(this.log);
        }
    }

    public static class OptimizerResult {
        private long originalFileSize;
        private long optimizedFileSize;
        private String fileName;
        private long width;
        private long height;
        private String dataUri;

        public long getOriginalFileSize() {
            return this.originalFileSize;
        }

        public long getOptimizedFileSize() {
            return this.optimizedFileSize;
        }

        public OptimizerResult(String fileName, long originalFileSize, long optimizedFileSize, long width, long height, String dataUri) {
            this.originalFileSize = originalFileSize;
            this.optimizedFileSize = optimizedFileSize;
            this.fileName = fileName;
            this.width = width;
            this.height = height;
            this.dataUri = dataUri;
        }
    }
}

