/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.launcher.impl.launchers;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.launcher.impl.VariableSubstitutor;
import org.apache.sling.feature.launcher.impl.launchers.FrameworkRunner;
import org.apache.sling.feature.launcher.spi.Launcher;
import org.apache.sling.feature.launcher.spi.LauncherPrepareContext;
import org.apache.sling.feature.launcher.spi.LauncherRunContext;

@ServiceProvider(value=Launcher.class)
public class FrameworkLauncher
implements Launcher {
    @Override
    public void prepare(LauncherPrepareContext context, ArtifactId frameworkId, Feature app) throws Exception {
        context.addAppJar(context.getArtifactFile(frameworkId));
    }

    @Override
    public int run(LauncherRunContext context, ClassLoader cl) throws Exception {
        VariableSubstitutor vs = new VariableSubstitutor(context);
        HashMap properties = new HashMap();
        context.getFrameworkProperties().forEach((key, value) -> properties.put(key, vs.replace((String)value).replace("{dollar}", "$")));
        if (context.getLogger().isDebugEnabled()) {
            context.getLogger().debug("Bundles:");
            for (Integer n : context.getBundleMap().keySet()) {
                context.getLogger().debug("-- Start Level {}", (Object)n);
                for (URL f : context.getBundleMap().get(n)) {
                    context.getLogger().debug("  - {}", (Object)f);
                }
            }
            context.getLogger().debug("Settings: ");
            for (Map.Entry entry : properties.entrySet()) {
                context.getLogger().debug("- {}={}", entry.getKey(), entry.getValue());
            }
            context.getLogger().debug("Configurations: ");
            for (Object[] objectArray : context.getConfigurations()) {
                if (objectArray[1] != null) {
                    context.getLogger().debug("- Factory {} - {}", objectArray[1], objectArray[0]);
                    continue;
                }
                context.getLogger().debug("- {}", objectArray[0]);
            }
            context.getLogger().debug("");
        }
        Class<?> runnerClass = cl.loadClass(this.getFrameworkRunnerClass());
        Constructor<?> constructor = runnerClass.getDeclaredConstructor(Map.class, Map.class, List.class, List.class);
        constructor.setAccessible(true);
        Callable restart = (Callable)constructor.newInstance(properties, context.getBundleMap(), context.getConfigurations(), context.getInstallableArtifacts());
        return (Integer)restart.call();
    }

    protected String getFrameworkRunnerClass() {
        return FrameworkRunner.class.getName();
    }
}

