/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.launcher.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.launcher.impl.Installation;
import org.apache.sling.feature.launcher.spi.LauncherPrepareContext;
import org.apache.sling.feature.launcher.spi.extensions.ExtensionContext;
import org.slf4j.Logger;

class ExtensionContextImpl
implements ExtensionContext {
    private final Installation installation;
    private final LauncherPrepareContext prepareContext;
    private final Map<ArtifactId, Feature> loadedFeatures;

    ExtensionContextImpl(LauncherPrepareContext lpc, Installation inst, Map<ArtifactId, Feature> featureMap) {
        this.prepareContext = lpc;
        this.installation = inst;
        this.loadedFeatures = featureMap;
    }

    @Override
    public Logger getLogger() {
        return this.prepareContext.getLogger();
    }

    @Override
    public void addBundle(Integer startLevel, URL file) {
        this.installation.addBundle(startLevel, file);
    }

    @Override
    public void addInstallableArtifact(URL file) {
        this.installation.addInstallableArtifact(file);
    }

    @Override
    public void addConfiguration(String pid, String factoryPid, Dictionary<String, Object> properties) {
        this.installation.addConfiguration(pid, factoryPid, properties);
    }

    @Override
    public void addFrameworkProperty(String key, String value) {
        this.installation.addFrameworkProperty(key, value);
    }

    @Override
    public Map<String, String> getFrameworkProperties() {
        return this.installation.getFrameworkProperties();
    }

    @Override
    public Map<Integer, List<URL>> getBundleMap() {
        return this.installation.getBundleMap();
    }

    @Override
    public List<Object[]> getConfigurations() {
        return this.installation.getConfigurations();
    }

    @Override
    public List<URL> getInstallableArtifacts() {
        return this.installation.getInstallableArtifacts();
    }

    @Override
    public void addAppJar(URL jar) {
        this.prepareContext.addAppJar(jar);
    }

    @Override
    public URL getArtifactFile(ArtifactId artifact) throws IOException {
        return this.prepareContext.getArtifactFile(artifact);
    }

    @Override
    public Feature getFeature(ArtifactId artifact) throws IOException {
        Feature f = this.loadedFeatures.get(artifact);
        if (f != null) {
            return f;
        }
        URL file = this.getArtifactFile(artifact);
        if (file == null) {
            return null;
        }
        try (InputStreamReader r = new InputStreamReader(file.openStream(), "UTF-8");){
            Feature feature = FeatureJSONReader.read(r, artifact.toMvnUrl());
            return feature;
        }
    }
}

