/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.json.Json;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Artifacts;
import org.apache.sling.feature.ExtensionState;
import org.apache.sling.feature.ExtensionType;

public class Extension {
    public static final String EXTENSION_NAME_REPOINIT = "repoinit";
    public static final String EXTENSION_NAME_CONTENT_PACKAGES = "content-packages";
    public static final String EXTENSION_NAME_ASSEMBLED_FEATURES = "assembled-features";
    public static final String EXTENSION_NAME_INTERNAL_DATA = "feature-internal-data";
    private final ExtensionType type;
    private final String name;
    private final Artifacts artifacts;
    private String text;
    private JsonStructure json;
    private final ExtensionState state;

    @Deprecated
    public Extension(ExtensionType t, String name, boolean required) {
        this(t, name, required ? ExtensionState.REQUIRED : ExtensionState.OPTIONAL);
    }

    public Extension(ExtensionType type, String name, ExtensionState state) {
        if (type == null || name == null || state == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        this.type = type;
        this.name = name;
        this.state = state;
        this.artifacts = type == ExtensionType.ARTIFACTS ? new Artifacts() : null;
    }

    public ExtensionType getType() {
        return this.type;
    }

    public ExtensionState getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public boolean isRequired() {
        return this.state == ExtensionState.REQUIRED;
    }

    @Deprecated
    public boolean isOptional() {
        return !this.isRequired();
    }

    public String getText() {
        if (this.type != ExtensionType.TEXT) {
            throw new IllegalStateException();
        }
        return this.text;
    }

    public void setText(String text) {
        if (this.type != ExtensionType.TEXT) {
            throw new IllegalStateException();
        }
        this.text = text;
    }

    public String getJSON() {
        if (this.type != ExtensionType.JSON) {
            throw new IllegalStateException();
        }
        return this.text;
    }

    public void setJSON(String text) {
        if (this.type != ExtensionType.JSON) {
            throw new IllegalStateException();
        }
        this.text = text;
        try (StringReader reader = new StringReader(text);){
            this.json = Json.createReader(reader).read();
        }
    }

    public JsonStructure getJSONStructure() {
        if (this.type != ExtensionType.JSON) {
            throw new IllegalStateException();
        }
        return this.json;
    }

    public void setJSONStructure(JsonStructure struct) {
        if (this.type != ExtensionType.JSON) {
            throw new IllegalStateException();
        }
        this.json = struct;
        try (StringWriter w = new StringWriter();){
            JsonWriter jw = Json.createWriter(w);
            jw.write(struct);
            w.flush();
            this.text = w.toString();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Not a json structure: " + struct, ioe);
        }
    }

    public Artifacts getArtifacts() {
        if (this.type != ExtensionType.ARTIFACTS) {
            throw new IllegalStateException();
        }
        return this.artifacts;
    }

    public Extension copy() {
        Extension c = new Extension(this.type, this.name, this.state);
        switch (this.type) {
            case TEXT: {
                c.setText(this.text);
                break;
            }
            case JSON: {
                c.setJSON(this.text);
                break;
            }
            case ARTIFACTS: {
                if (this.artifacts == null) break;
                for (Artifact a : this.artifacts) {
                    c.getArtifacts().add(a.copy(a.getId()));
                }
                break;
            }
        }
        return c;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.name.equals(((Extension)obj).name);
    }

    public String toString() {
        return "Extension [type=" + (Object)((Object)this.type) + ", name=" + this.name + "]";
    }
}

