/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature;

import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.osgi.framework.Version;

public class ExecutionEnvironmentExtension {
    public static final String EXTENSION_NAME = "execution-environment";
    private final Artifact framework;
    private final Version javaVersion;
    private final String javaOptions;

    public static ExecutionEnvironmentExtension getExecutionEnvironmentExtension(Feature feature) {
        Extension ext = feature == null ? null : feature.getExtensions().getByName(EXTENSION_NAME);
        return ExecutionEnvironmentExtension.getExecutionEnvironmentExtension(ext);
    }

    public static ExecutionEnvironmentExtension getExecutionEnvironmentExtension(Extension ext) {
        if (ext == null) {
            return null;
        }
        if (ext.getType() != ExtensionType.JSON) {
            throw new IllegalArgumentException("Extension " + ext.getName() + " must have JSON type");
        }
        return new ExecutionEnvironmentExtension(ext.getJSONStructure());
    }

    private ExecutionEnvironmentExtension(JsonStructure structure) {
        JsonValue fwk = structure.asJsonObject().getOrDefault("framework", null);
        this.framework = fwk != null ? new Artifact(fwk) : null;
        JsonValue jv = structure.asJsonObject().getOrDefault("javaVersion", null);
        if (jv != null) {
            if (jv.getValueType() != JsonValue.ValueType.STRING) {
                throw new IllegalArgumentException("javaVersion is not of type String");
            }
            this.javaVersion = Version.parseVersion((String)((JsonString)jv).getString());
        } else {
            this.javaVersion = null;
        }
        JsonValue jo = structure.asJsonObject().getOrDefault("javaOptions", null);
        if (jo != null) {
            if (jo.getValueType() != JsonValue.ValueType.STRING) {
                throw new IllegalArgumentException("javaOptions is not of type String");
            }
            this.javaOptions = ((JsonString)jo).getString();
        } else {
            this.javaOptions = null;
        }
    }

    public Artifact getFramework() {
        return this.framework;
    }

    public Version getJavaVersion() {
        return this.javaVersion;
    }

    public String getJavaOptions() {
        return this.javaOptions;
    }
}

