/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factory.model.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.FeatureBuilder;
import org.apache.sling.feature.io.archive.ArchiveReader;
import org.apache.sling.feature.io.artifacts.ArtifactManager;
import org.apache.sling.feature.io.artifacts.ArtifactManagerConfig;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.feature.spi.context.ExtensionHandler;
import org.apache.sling.installer.api.tasks.InstallTask;
import org.apache.sling.installer.api.tasks.InstallTaskFactory;
import org.apache.sling.installer.api.tasks.RegisteredResource;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.ResourceTransformer;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.api.tasks.TransformationResult;
import org.apache.sling.installer.factory.model.impl.InstallContext;
import org.apache.sling.installer.factory.model.impl.InstallFeatureModelTask;
import org.apache.sling.installer.factory.model.impl.UninstallFeatureModelTask;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={InstallTaskFactory.class, ResourceTransformer.class})
@Designate(ocd=Config.class)
public class FeatureModelInstallerPlugin
implements InstallTaskFactory,
ResourceTransformer {
    public static final String FILE_EXTENSION = ".json";
    public static final String TYPE_FEATURE_MODEL = "featuremodel";
    public static final String ATTR_MODEL = "feature";
    public static final String ATTR_ID = "featureId";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BundleContext bundleContext;
    private final ArtifactManager artifactManager;
    private final List<Pattern> classifierPatterns = new ArrayList<Pattern>();
    private final File storageDirectory;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile List<ExtensionHandler> extensionHandlers;

    @Activate
    public FeatureModelInstallerPlugin(BundleContext ctx, Config config) throws IOException {
        this.bundleContext = ctx;
        this.storageDirectory = this.bundleContext.getDataFile("repository");
        ArtifactManagerConfig amCfg = new ArtifactManagerConfig();
        amCfg.setUseMvn(config.useMvn());
        if (this.storageDirectory != null) {
            amCfg.setCacheDirectory(this.storageDirectory);
        }
        ArrayList<String> repos = new ArrayList<String>(Arrays.asList(amCfg.getRepositoryUrls()));
        if (config.repositories() != null && config.repositories().length > 0) {
            for (String r : config.repositories()) {
                if (r.trim().isEmpty()) continue;
                repos.add(r);
            }
        }
        amCfg.setRepositoryUrls(repos.toArray(new String[repos.size()]));
        this.artifactManager = ArtifactManager.getArtifactManager((ArtifactManagerConfig)amCfg);
        if (config.classifierPatterns() != null) {
            for (String text : config.classifierPatterns()) {
                if (text == null || text.trim().isEmpty()) continue;
                if (":".equals(text.trim())) {
                    this.classifierPatterns.add(Pattern.compile("^$"));
                    continue;
                }
                this.classifierPatterns.add(Pattern.compile(FeatureModelInstallerPlugin.toRegexPattern(text.trim())));
            }
        }
    }

    public TransformationResult[] transform(RegisteredResource resource) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        if (resource.getType().equals("file") && resource.getURL().endsWith(FILE_EXTENSION)) {
            try (InputStreamReader reader = new InputStreamReader(resource.getInputStream(), "UTF-8");){
                features.add(FeatureJSONReader.read((Reader)reader, (String)resource.getURL()));
            }
            catch (IOException ioe) {
                this.logger.info("Unable to read feature model from " + resource.getURL(), (Throwable)ioe);
            }
        }
        if (resource.getType().equals("file") && resource.getURL().endsWith(".far")) {
            try (InputStream is = resource.getInputStream();){
                features.addAll(ArchiveReader.read((InputStream)is, null));
            }
            catch (IOException ioe) {
                this.logger.info("Unable to read feature model from " + resource.getURL(), (Throwable)ioe);
            }
        }
        if (!features.isEmpty()) {
            if (this.storageDirectory != null) {
                for (Feature feature : features) {
                    File featureFile = new File(this.storageDirectory, feature.getId().toMvnPath().replace('/', File.separatorChar));
                    if (featureFile.exists()) continue;
                    featureFile.getParentFile().mkdirs();
                    try (FileWriter writer = new FileWriter(featureFile);){
                        FeatureJSONWriter.write((Writer)writer, (Feature)feature);
                    }
                    catch (IOException ioe) {
                        this.logger.error("Unable to write feature to " + featureFile + ":" + ioe.getMessage(), (Throwable)ioe);
                    }
                }
            }
            boolean error = false;
            ArrayList<TransformationResult> result = new ArrayList<TransformationResult>();
            for (Feature feature : features) {
                if (!this.classifierMatches(feature.getId().getClassifier())) continue;
                if (!feature.isAssembled()) {
                    BuilderContext ctx = new BuilderContext(this.artifactManager.toFeatureProvider());
                    ctx.setArtifactProvider((ArtifactProvider)this.artifactManager);
                    feature = FeatureBuilder.assemble((Feature)feature, (BuilderContext)ctx);
                }
                FeatureBuilder.resolveVariables((Feature)feature, null);
                String featureJson = null;
                try (StringWriter sw = new StringWriter();){
                    FeatureJSONWriter.write((Writer)sw, (Feature)feature);
                    featureJson = sw.toString();
                }
                catch (IOException ioe) {
                    this.logger.info("Unable to read feature model from " + resource.getURL(), (Throwable)ioe);
                }
                if (featureJson != null) {
                    TransformationResult tr = new TransformationResult();
                    tr.setResourceType(TYPE_FEATURE_MODEL);
                    tr.setId(feature.getId().toMvnId());
                    tr.setVersion(feature.getId().getOSGiVersion());
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put(ATTR_MODEL, featureJson);
                    attributes.put(ATTR_ID, feature.getId().toMvnId());
                    tr.setAttributes(attributes);
                    result.add(tr);
                    continue;
                }
                error = true;
                break;
            }
            if (!error) {
                return result.toArray(new TransformationResult[result.size()]);
            }
        }
        return null;
    }

    public InstallTask createTask(TaskResourceGroup group) {
        TaskResource rsrc = group.getActiveResource();
        if (!TYPE_FEATURE_MODEL.equals(rsrc.getType())) {
            return null;
        }
        if (rsrc.getState() == ResourceState.UNINSTALL) {
            return new UninstallFeatureModelTask(group, this.bundleContext);
        }
        InstallContext ctx = new InstallContext(this.artifactManager, this.storageDirectory);
        return new InstallFeatureModelTask(group, ctx, this.bundleContext, this.extensionHandlers);
    }

    boolean classifierMatches(String classifier) {
        boolean select;
        block2: {
            Pattern pattern;
            select = this.classifierPatterns.isEmpty();
            if (select) break block2;
            if (classifier == null) {
                classifier = "";
            }
            Iterator<Pattern> iterator = this.classifierPatterns.iterator();
            while (iterator.hasNext() && !(select = (pattern = iterator.next()).matcher(classifier).matches())) {
            }
        }
        return select;
    }

    private static String toRegexPattern(String pattern) {
        StringBuilder stringBuilder = new StringBuilder("^");
        int index = 0;
        block3: while (index < pattern.length()) {
            char currentChar = pattern.charAt(index++);
            switch (currentChar) {
                case '*': {
                    stringBuilder.append("[^/]*");
                    continue block3;
                }
            }
            if (FeatureModelInstallerPlugin.isRegexMeta(currentChar)) {
                stringBuilder.append(Pattern.quote(Character.toString(currentChar)));
                continue;
            }
            stringBuilder.append(currentChar);
        }
        return stringBuilder.append('$').toString();
    }

    private static boolean isRegexMeta(char character) {
        return "<([{\\^-=$!|]})?*+.>".indexOf(character) != -1;
    }

    @ObjectClassDefinition(name="Apache Sling Feature Model Installer", description="This component provides support for feature models to the OSGi installer")
    public static @interface Config {
        @AttributeDefinition(name="Use Apache Maven", description="If enabled, missing artifacts from a feature are tried by invoking the mvn command")
        public boolean useMvn() default true;

        @AttributeDefinition(name="Repository URLs", description="Additional repository URLs to fetch artifacts")
        public String[] repositories();

        @AttributeDefinition(name="Classifier Patterns", description="Patterns for selecting the features to handle based on the classifier. Without a configuration all features are handled. The patterns can use an asteriks to match any characters in the classifier. The special token ':' can be used to match the empty classifier.")
        public String[] classifierPatterns();
    }
}

