/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.felix.cm.json.Configurations;

public class Configuration
implements Comparable<Configuration> {
    public static final String CONFIGURATOR_PREFIX = ":configurator:";
    public static final String PROP_PREFIX = ":configurator:feature:";
    public static final String PROP_ARTIFACT_ID = ":configurator:feature:service.bundleLocation";
    private final String pid;
    private final Dictionary<String, Object> properties = Configurations.newConfiguration();

    public Configuration(String pid) {
        if (pid == null) {
            throw new IllegalArgumentException("pid must not be null");
        }
        this.pid = pid;
    }

    @Override
    public int compareTo(Configuration o) {
        return this.pid.compareTo(o.pid);
    }

    public String getPid() {
        return this.pid;
    }

    public boolean isFactoryConfiguration() {
        return Configuration.isFactoryConfiguration(this.pid);
    }

    public String getFactoryPid() {
        return Configuration.getFactoryPid(this.pid);
    }

    public String getName() {
        return Configuration.getName(this.pid);
    }

    public static boolean isFactoryConfiguration(String pid) {
        return pid.contains("~");
    }

    public static String getFactoryPid(String pid) {
        int pos = pid.indexOf(126);
        if (pos != -1) {
            return pid.substring(0, pos);
        }
        return null;
    }

    public static String getName(String pid) {
        int pos = pid.indexOf(126);
        if (pos != -1) {
            return pid.substring(pos + 1);
        }
        return null;
    }

    public Dictionary<String, Object> getProperties() {
        return this.properties;
    }

    public Dictionary<String, Object> getConfigurationProperties() {
        Hashtable<String, Object> p = new Hashtable<String, Object>();
        Enumeration<String> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key.startsWith(CONFIGURATOR_PREFIX)) continue;
            ((Dictionary)p).put(key, this.properties.get(key));
        }
        return p;
    }

    public Configuration copy(String aPid) {
        Configuration result = new Configuration(aPid);
        Enumeration<String> keyEnum = this.getProperties().keys();
        while (keyEnum.hasMoreElements()) {
            String key = keyEnum.nextElement();
            result.getProperties().put(key, this.getProperties().get(key));
        }
        return result;
    }

    public String toString() {
        return "Configuration [pid=" + this.pid + ", properties=" + this.properties + "]";
    }
}

