/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.unpack.impl.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionState;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.extension.unpack.Unpack;
import org.apache.sling.feature.io.json.FeatureJSONWriter;

public class Converter {
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes();

    public static void main(String[] args) throws Exception {
        if (args.length > 4) {
            Predicate<InputStream> check;
            ArtifactId id = ArtifactId.fromMvnId((String)args[0]);
            String name = args[1];
            if (name == null || name.trim().isEmpty()) {
                throw new IllegalStateException("Invalid extension name: " + name);
            }
            File featureFile = new File(args[2]);
            if (!featureFile.getParentFile().isDirectory() && !featureFile.mkdirs()) {
                throw new IOException("Unable to create target dir: " + featureFile.getParentFile());
            }
            File base = new File(args[3]);
            if (!base.isDirectory() && !base.mkdirs()) {
                throw new IOException("Unable to create base dir: " + base);
            }
            String key = null;
            String value = null;
            ArrayList<String> urls = new ArrayList<String>();
            for (int i = 4; i < args.length; ++i) {
                if (args[i].startsWith("key=")) {
                    key = args[i].substring("key=".length());
                    continue;
                }
                if (args[i].startsWith("value=")) {
                    value = args[i].substring("value=".length());
                    continue;
                }
                urls.addAll(Arrays.asList(args[i].split(" ")).stream().map(String::trim).filter(((Predicate<String>)String::isEmpty).negate()).collect(Collectors.toList()));
            }
            if (key != null && !key.trim().isEmpty() && value != null && !value.trim().isEmpty()) {
                String keyF = key;
                String valueF = value;
                check = stream -> Unpack.handles(keyF, valueF, stream);
            } else {
                check = inputStream -> true;
            }
            List<String> unhandled = Converter.convert(id, name, featureFile, base, check, urls);
            System.out.println(String.join((CharSequence)" ", unhandled));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> convert(ArtifactId featureId, String extensionName, File featureFile, File repository, Predicate<InputStream> filter, List<String> urls) throws Exception {
        Feature feature = new Feature(featureId);
        ArrayList<String> unhandled = new ArrayList<String>();
        Extension extension = new Extension(ExtensionType.ARTIFACTS, extensionName, ExtensionState.OPTIONAL);
        for (String urlString : urls) {
            URL url = new URL(urlString);
            File tmp = File.createTempFile("unpack", ".zip");
            try (DigestInputStream inputStream = new DigestInputStream(url.openStream(), MessageDigest.getInstance("SHA-512"));){
                Files.copy(inputStream, tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                String digest = Converter.bytesToHex(inputStream.getMessageDigest().digest());
                if (filter.test(new FileInputStream(tmp))) {
                    Artifact artifact = new Artifact(new ArtifactId(featureId.getGroupId(), featureId.getArtifactId(), featureId.getVersion(), (featureId.getClassifier() != null ? featureId.getClassifier() + "-" : "") + digest, "zip"));
                    extension.getArtifacts().add(artifact);
                    File target = new File(repository, artifact.getId().toMvnPath());
                    if (!target.getParentFile().isDirectory() && !target.getParentFile().mkdirs()) {
                        throw new IOException("Unable to create parent dir: " + target.getParentFile());
                    }
                    Files.move(tmp.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                unhandled.add(urlString);
            }
            finally {
                tmp.delete();
            }
        }
        feature.getExtensions().add((Object)extension);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(featureFile), StandardCharsets.UTF_8);){
            FeatureJSONWriter.write((Writer)writer, (Feature)feature);
        }
        return unhandled;
    }

    static String bytesToHex(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }
}

