/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.packaging;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import shaded.org.apache.jackrabbit.vault.packaging.PackageId;
import shaded.org.apache.jackrabbit.vault.packaging.VersionRange;

public class Dependency {
    public static final Dependency[] EMPTY = new Dependency[0];
    private final String groupId;
    private final String name;
    private final VersionRange range;
    private final String str;

    public Dependency(@Nonnull String groupId, @Nonnull String name, @Nullable VersionRange range) {
        if (groupId.startsWith("/etc/packages/")) {
            groupId = groupId.substring("/etc/packages/".length());
        }
        this.groupId = groupId;
        this.name = name;
        this.range = range == null ? VersionRange.INFINITE : range;
        StringBuilder b = new StringBuilder();
        if (groupId.length() > 0 || !VersionRange.INFINITE.equals(this.range)) {
            b.append(groupId);
            b.append(":");
        }
        b.append(name);
        if (!VersionRange.INFINITE.equals(this.range)) {
            b.append(":");
            b.append(range);
        }
        this.str = b.toString();
    }

    public Dependency(@Nonnull PackageId id) {
        this(id.getGroup(), id.getName(), new VersionRange(id.getVersion()));
    }

    @Nonnull
    public String getGroup() {
        return this.groupId;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public VersionRange getRange() {
        return this.range;
    }

    @Deprecated
    @Nonnull
    public String getPath() {
        StringBuilder b = new StringBuilder();
        if (this.groupId.length() > 0) {
            if (this.groupId.charAt(0) != '/') {
                b.append("/etc/packages/");
            }
            b.append(this.groupId);
            b.append("/");
        } else {
            b.append("/etc/packages/");
        }
        b.append(this.name);
        return b.toString();
    }

    public boolean matches(@Nonnull PackageId id) {
        return this.groupId.equals(id.getGroup()) && this.name.equals(id.getName()) && this.range.isInRange(id.getVersion());
    }

    @Nullable
    public static Dependency fromString(@Nullable String str) {
        String name;
        if (str == null || str.length() == 0) {
            return null;
        }
        String[] segs = str.split(":");
        String groupId = "";
        String range = null;
        if (segs.length == 1) {
            name = segs[0];
            int idx = name.lastIndexOf(47);
            if (idx >= 0) {
                groupId = name.substring(0, idx);
                name = name.substring(idx + 1);
            }
        } else if (segs.length == 2) {
            int idx;
            groupId = segs[0];
            name = segs[1];
            boolean isVersion = true;
            if (name.length() > 0) {
                char c = name.charAt(0);
                boolean bl = isVersion = Character.isDigit(c) || c == '[' || c == ')';
            }
            if ((idx = name.lastIndexOf(47)) >= 0 && groupId.length() == 0) {
                groupId = name.substring(0, idx);
                name = name.substring(idx + 1);
            } else {
                idx = groupId.lastIndexOf(47);
                if (idx >= 0 && isVersion) {
                    groupId = segs[0].substring(0, idx);
                    name = segs[0].substring(idx + 1);
                    range = segs[1];
                }
            }
        } else {
            groupId = segs[0];
            name = segs[1];
            range = segs[2];
        }
        return new Dependency(groupId, name, range == null ? null : VersionRange.fromString(range));
    }

    @Nonnull
    public static Dependency[] parse(@Nonnull String str) {
        Dependency dep;
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        boolean inRange = false;
        int start = 0;
        boolean wasSeg = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == ',') {
                if (!inRange) {
                    deps.add(Dependency.fromString(str.substring(start, i)));
                    start = i + 1;
                }
            } else if (c == '[' || c == '(') {
                if (wasSeg) {
                    inRange = true;
                }
            } else if (c == ']' || c == ')') {
                inRange = false;
            }
            wasSeg = c == ':';
        }
        if (start < str.length() && (dep = Dependency.fromString(str.substring(start))) != null) {
            deps.add(dep);
        }
        return deps.toArray(new Dependency[deps.size()]);
    }

    @Nonnull
    public static Dependency[] fromString(String ... str) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>(str.length);
        for (String s : str) {
            Dependency dep = Dependency.fromString(s);
            if (dep == null) continue;
            deps.add(dep);
        }
        return deps.toArray(new Dependency[deps.size()]);
    }

    @Nonnull
    public static String toString(Dependency ... deps) {
        String delim = "";
        StringBuilder b = new StringBuilder();
        for (Dependency dep : deps) {
            if (dep == null) continue;
            b.append(delim).append(dep);
            delim = ",";
        }
        return b.toString();
    }

    @Nonnull
    public String toString() {
        return this.str;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Dependency && this.str.equals(obj.toString());
    }

    public int hashCode() {
        return this.str.hashCode();
    }
}

