/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.fs.spi.impl.jcr20;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.jackrabbit.spi.QNodeTypeDefinition;
import shaded.org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import shaded.org.apache.jackrabbit.spi.commons.nodetype.NodeTypeDefinitionFactory;
import shaded.org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import shaded.org.apache.jackrabbit.vault.fs.spi.DefaultNodeTypeSet;
import shaded.org.apache.jackrabbit.vault.fs.spi.NodeTypeInstaller;
import shaded.org.apache.jackrabbit.vault.fs.spi.NodeTypeSet;
import shaded.org.apache.jackrabbit.vault.fs.spi.ProgressTracker;
import shaded.org.apache.jackrabbit.vault.fs.spi.impl.jcr20.JcrNamespaceHelper;

public class JcrNodeTypeInstaller
implements NodeTypeInstaller {
    private static final Logger log = LoggerFactory.getLogger(JcrNodeTypeInstaller.class);
    private final Session session;

    public JcrNodeTypeInstaller(Session session) {
        this.session = session;
    }

    @Override
    public Collection<NodeType> install(ProgressTracker tracker, NodeTypeSet types) throws IOException, RepositoryException {
        NodeTypeManager ntMgr = this.session.getWorkspace().getNodeTypeManager();
        JcrNamespaceHelper nsHelper = new JcrNamespaceHelper(this.session, tracker);
        DefaultNodeTypeSet set = types instanceof DefaultNodeTypeSet ? (DefaultNodeTypeSet)types : new DefaultNodeTypeSet(types);
        log.trace("Removing registered nodetypes");
        DefaultNamePathResolver npResolver = new DefaultNamePathResolver(this.session);
        NodeTypeIterator iter = ntMgr.getAllNodeTypes();
        while (iter.hasNext()) {
            NodeType nt = iter.nextNodeType();
            set.remove(npResolver.getQName(nt.getName()));
        }
        ProgressTrackerListener.Mode mode = null;
        if (tracker != null) {
            mode = tracker.setMode(ProgressTrackerListener.Mode.TEXT);
        }
        nsHelper.registerNamespaces(set.getNamespaceMapping().getPrefixToURIMapping());
        NodeTypeDefinitionFactory fac = new NodeTypeDefinitionFactory(this.session);
        List<NodeTypeDefinition> nodeTypes = fac.create(set.getNodeTypes().values());
        if (nodeTypes.size() > 0) {
            try {
                ntMgr.registerNodeTypes(nodeTypes.toArray(new NodeTypeDefinition[nodeTypes.size()]), true);
            }
            catch (UnsupportedOperationException e) {
                log.error("Unable to install node types.");
                throw e;
            }
        }
        for (QNodeTypeDefinition t : set.getRemoved().values()) {
            String name = npResolver.getJCRName(t.getName());
            this.track(tracker, "-", name);
        }
        LinkedList<NodeType> nts = new LinkedList<NodeType>();
        for (QNodeTypeDefinition t : set.getNodeTypes().values()) {
            String name = npResolver.getJCRName(t.getName());
            this.track(tracker, "A", name);
            nts.add(this.session.getWorkspace().getNodeTypeManager().getNodeType(name));
        }
        if (tracker != null) {
            tracker.setMode(mode);
        }
        return nts;
    }

    private void track(ProgressTracker tracker, String action, String path) {
        log.debug("{} {}", (Object)action, (Object)path);
        if (tracker != null) {
            tracker.track(action, path);
        }
    }
}

