/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.fs.spi.impl.jcr20;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.security.Privilege;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.jackrabbit.api.JackrabbitWorkspace;
import shaded.org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import shaded.org.apache.jackrabbit.spi.Name;
import shaded.org.apache.jackrabbit.spi.PrivilegeDefinition;
import shaded.org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import shaded.org.apache.jackrabbit.vault.fs.spi.PrivilegeDefinitions;
import shaded.org.apache.jackrabbit.vault.fs.spi.PrivilegeInstaller;
import shaded.org.apache.jackrabbit.vault.fs.spi.ProgressTracker;
import shaded.org.apache.jackrabbit.vault.fs.spi.impl.jcr20.JcrNamespaceHelper;

public class JackrabbitPrivilegeInstaller
implements PrivilegeInstaller {
    private static final Logger log = LoggerFactory.getLogger(JackrabbitPrivilegeInstaller.class);
    private final Session session;

    public JackrabbitPrivilegeInstaller(Session session) {
        this.session = session;
    }

    @Override
    public Collection<Privilege> install(ProgressTracker tracker, PrivilegeDefinitions defs) throws IOException, RepositoryException {
        Workspace wsp = this.session.getWorkspace();
        if (!(wsp instanceof JackrabbitWorkspace)) {
            throw new RepositoryException("Unable to register privileges. No JackrabbitWorkspace.");
        }
        PrivilegeManager mgr = ((JackrabbitWorkspace)wsp).getPrivilegeManager();
        ProgressTrackerListener.Mode mode = null;
        if (tracker != null) {
            mode = tracker.setMode(ProgressTrackerListener.Mode.TEXT);
        }
        JcrNamespaceHelper nsHelper = new JcrNamespaceHelper(this.session, tracker);
        nsHelper.registerNamespaces(defs.getNamespaceMapping().getPrefixToURIMapping());
        LinkedList<Privilege> registeredPrivs = new LinkedList<Privilege>();
        for (PrivilegeDefinition def : defs.getDefinitions()) {
            String name = this.getJCRName(def.getName());
            Privilege priv = null;
            try {
                priv = mgr.getPrivilege(name);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            if (priv == null) {
                String[] aggregateNames = new String[def.getDeclaredAggregateNames().size()];
                int i = 0;
                for (Name n : def.getDeclaredAggregateNames()) {
                    aggregateNames[i++] = this.getJCRName(n);
                }
                registeredPrivs.add(mgr.registerPrivilege(name, def.isAbstract(), aggregateNames));
                this.track(tracker, "A", name);
                continue;
            }
            this.track(tracker, "-", name);
        }
        if (tracker != null) {
            tracker.setMode(mode);
        }
        return registeredPrivs;
    }

    private void track(ProgressTracker tracker, String action, String path) {
        log.debug("{} {}", (Object)action, (Object)path);
        if (tracker != null) {
            tracker.track(action, path);
        }
    }

    private String getJCRName(Name name) {
        StringBuilder str = new StringBuilder("{");
        str.append(name.getNamespaceURI());
        str.append("}");
        str.append(name.getLocalName());
        return str.toString();
    }
}

