/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.fs.impl;

import java.io.IOException;
import javax.jcr.RepositoryException;
import shaded.org.apache.jackrabbit.vault.fs.api.Aggregate;
import shaded.org.apache.jackrabbit.vault.fs.api.Artifact;
import shaded.org.apache.jackrabbit.vault.fs.api.ArtifactSet;
import shaded.org.apache.jackrabbit.vault.fs.api.ImportInfo;
import shaded.org.apache.jackrabbit.vault.fs.impl.AggregateImpl;
import shaded.org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;

public class AggregateBuilder {
    private final AggregateImpl aggregate;
    private final String reposName;
    private ArtifactSetImpl artifacts = new ArtifactSetImpl();

    AggregateBuilder(AggregateImpl aggregate, ArtifactSet artifacts) {
        this.aggregate = aggregate;
        this.reposName = null;
        this.artifacts.addAll(artifacts);
        this.artifacts.setCoverage(artifacts.getCoverage());
    }

    AggregateBuilder(AggregateImpl parent, String reposName) {
        this.aggregate = parent;
        this.reposName = reposName;
    }

    public ArtifactSetImpl getArtifacts() {
        this.assertOpen();
        return this.artifacts;
    }

    public void addArtifact(Artifact artifact) {
        this.assertOpen();
        this.artifacts.add(artifact);
    }

    public void addArtifacts(ArtifactSetImpl artifacts) {
        this.assertOpen();
        this.artifacts.addAll(artifacts);
    }

    public Aggregate getAggregate() {
        return this.aggregate;
    }

    public String getReposName() {
        return this.reposName;
    }

    public ImportInfo close() throws RepositoryException, IOException {
        this.assertOpen();
        try {
            ImportInfo importInfo = this.aggregate.writeArtifacts(this.artifacts, this.reposName);
            return importInfo;
        }
        finally {
            this.artifacts = null;
        }
    }

    private void assertOpen() {
        if (this.artifacts == null) {
            throw new IllegalStateException("Output closed.");
        }
    }
}

