/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.fs.filter;

import java.util.regex.Pattern;
import shaded.org.apache.jackrabbit.vault.fs.api.DumpContext;
import shaded.org.apache.jackrabbit.vault.fs.api.PathFilter;
import shaded.org.apache.jackrabbit.vault.fs.api.PathMapping;

public class DefaultPathFilter
implements PathFilter {
    private Pattern regex;

    public DefaultPathFilter() {
    }

    public DefaultPathFilter(String pattern) {
        this.setPattern(pattern);
    }

    public void setPattern(String pattern) {
        this.regex = Pattern.compile(pattern);
    }

    public String getPattern() {
        return this.regex.pattern();
    }

    @Override
    public boolean matches(String path) {
        return this.regex.matcher(path).matches();
    }

    @Override
    public boolean isAbsolute() {
        return this.regex.pattern().startsWith("/");
    }

    @Override
    public PathFilter translate(PathMapping mapping) {
        if (mapping == null) {
            return this;
        }
        String pattern = this.regex.pattern();
        if (!pattern.startsWith("/")) {
            return this;
        }
        return new DefaultPathFilter(mapping.map(pattern));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPathFilter)) {
            return false;
        }
        DefaultPathFilter that = (DefaultPathFilter)o;
        return this.regex.toString().equals(that.regex.toString());
    }

    public int hashCode() {
        return this.regex.hashCode();
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        ctx.printf(isLast, "%s:", this.getClass().getSimpleName());
        ctx.indent(isLast);
        ctx.printf(true, "regex: %s", this.regex.toString());
        ctx.outdent();
    }
}

