/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.vault.fs.api;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeNameList {
    private static final Logger log = LoggerFactory.getLogger(NodeNameList.class);
    private final LinkedHashSet<String> names = new LinkedHashSet();

    public void addName(String name) {
        this.names.add(name);
    }

    public boolean contains(String name) {
        return this.names.contains(name);
    }

    public LinkedHashSet<String> getNames() {
        return this.names;
    }

    public boolean needsReorder(Node parent) throws RepositoryException {
        return this.names.size() > 1 && parent.getPrimaryNodeType().hasOrderableChildNodes();
    }

    public boolean isEmpty() {
        return this.names.isEmpty();
    }

    public boolean restoreOrder(Node parent) throws RepositoryException {
        if (!parent.isCheckedOut()) {
            log.warn("Unable to restore order of a checked-in node: " + parent.getPath());
            return false;
        }
        int size = this.names.size();
        String last = null;
        ArrayList<String> list = new ArrayList<String>(this.names);
        ListIterator<String> iter = list.listIterator(size);
        while (iter.hasPrevious()) {
            String prev = iter.previous();
            if (!parent.hasNode(prev)) continue;
            log.trace("ordering {} before {}", (Object)prev, last);
            try {
                parent.orderBefore(prev, last);
            }
            catch (Exception e) {
                String path = parent.getPath() + "/" + prev;
                log.warn("Ignoring unexpected error during reorder of {}: {}", (Object)path, (Object)e.toString());
            }
            last = prev;
        }
        return true;
    }
}

