/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.jackrabbit.spi.commons.conversion;

import javax.jcr.NamespaceException;
import shaded.org.apache.jackrabbit.spi.Name;
import shaded.org.apache.jackrabbit.spi.NameFactory;
import shaded.org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import shaded.org.apache.jackrabbit.spi.commons.conversion.NameParser;
import shaded.org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import shaded.org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;

public class ParsingNameResolver
implements NameResolver {
    private final NameFactory nameFactory;
    private final NamespaceResolver resolver;

    public ParsingNameResolver(NameFactory nameFactory, NamespaceResolver resolver) {
        this.nameFactory = nameFactory;
        this.resolver = resolver;
    }

    @Override
    public Name getQName(String jcrName) throws IllegalNameException, NamespaceException {
        return NameParser.parse(jcrName, this.resolver, this.nameFactory);
    }

    @Override
    public String getJCRName(Name name) throws NamespaceException {
        String uri = name.getNamespaceURI();
        if (uri.length() == 0) {
            return name.getLocalName();
        }
        return this.resolver.getPrefix(uri) + ":" + name.getLocalName();
    }
}

