/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.content;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.io.IOUtils;
import org.apache.sling.feature.launcher.spi.LauncherPrepareContext;
import org.apache.sling.feature.launcher.spi.extensions.ExtensionContext;
import org.apache.sling.feature.launcher.spi.extensions.ExtensionHandler;
import shaded.org.apache.jackrabbit.vault.packaging.PackageExistsException;
import shaded.org.apache.jackrabbit.vault.packaging.PackageId;
import shaded.org.apache.jackrabbit.vault.packaging.SubPackageHandling;
import shaded.org.apache.jackrabbit.vault.packaging.registry.ExecutionPlanBuilder;
import shaded.org.apache.jackrabbit.vault.packaging.registry.PackageTask;
import shaded.org.apache.jackrabbit.vault.packaging.registry.impl.FSPackageRegistry;

public class ContentHandler
implements ExtensionHandler {
    public static final String PACKAGEREGISTRY_HOME = "packageregistry.home";
    private static final String REPOSITORY_HOME = "repository.home";
    private static final String REGISTRY_FOLDER = "packageregistry";

    private static ExecutionPlanBuilder buildExecutionPlan(Collection<Artifact> artifacts, Set<PackageId> satisfiedPackages, LauncherPrepareContext prepareContext, File registryHome) throws Exception {
        ArrayList<File> packageReferences = new ArrayList<File>();
        for (Artifact a : artifacts) {
            URL file = prepareContext.getArtifactFile(a.getId());
            File tmp = IOUtils.getFileFromURL((URL)file, (boolean)true, null);
            if (tmp.length() <= 0L) continue;
            packageReferences.add(tmp);
        }
        if (!registryHome.exists()) {
            registryHome.mkdirs();
        }
        FSPackageRegistry registry = new FSPackageRegistry(registryHome);
        ExecutionPlanBuilder builder = registry.createExecutionPlan();
        builder.with(satisfiedPackages);
        for (File pkgFile : packageReferences) {
            try {
                PackageId pid = registry.registerExternal(pkgFile, false);
                ContentHandler.extractSubPackages(registry, builder, pid);
                builder.addTask().with(pid).with(PackageTask.Type.EXTRACT);
            }
            catch (PackageExistsException packageExistsException) {}
        }
        builder.validate();
        satisfiedPackages.addAll(builder.preview());
        return builder;
    }

    private static void extractSubPackages(FSPackageRegistry registry, ExecutionPlanBuilder builder, PackageId pid) throws IOException {
        Map<PackageId, SubPackageHandling.Option> subPkgs = registry.getInstallState(pid).getSubPackages();
        if (!subPkgs.isEmpty()) {
            for (PackageId subId : subPkgs.keySet()) {
                SubPackageHandling.Option opt = subPkgs.get(subId);
                if (opt == SubPackageHandling.Option.IGNORE) continue;
                builder.addTask().with(subId).with(PackageTask.Type.EXTRACT);
                ContentHandler.extractSubPackages(registry, builder, subId);
            }
        }
    }

    public boolean handle(ExtensionContext context, Extension extension) throws Exception {
        File registryHome = this.getRegistryHomeDir(context);
        if (extension.getType() == ExtensionType.ARTIFACTS && extension.getName().equals("content-packages")) {
            TreeMap<Integer, Collection> orderedArtifacts = new TreeMap<Integer, Collection>();
            for (Artifact a : extension.getArtifacts()) {
                int order = a.getMetadata().get("start-order") != null ? a.getStartOrder() : Integer.MAX_VALUE;
                orderedArtifacts.computeIfAbsent(order, id -> new ArrayList()).add(a);
            }
            ArrayList<String> executionPlans = new ArrayList<String>();
            HashSet<PackageId> satisfiedPackages = new HashSet<PackageId>();
            for (Object key : orderedArtifacts.keySet()) {
                Collection artifacts = (Collection)orderedArtifacts.get(key);
                ExecutionPlanBuilder builder = ContentHandler.buildExecutionPlan(artifacts, satisfiedPackages, (LauncherPrepareContext)context, registryHome);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                builder.save(baos);
                executionPlans.add(baos.toString("UTF-8"));
            }
            Configuration initcfg = new Configuration("org.apache.sling.jcr.packageinit.impl.ExecutionPlanRepoInitializer");
            initcfg.getProperties().put("executionplans", executionPlans.toArray(new String[executionPlans.size()]));
            initcfg.getProperties().put("statusfilepath", registryHome.getAbsolutePath() + "/executedplans.file");
            context.addConfiguration(initcfg.getPid(), null, initcfg.getProperties());
            Configuration registrycfg = new Configuration("org.apache.jackrabbit.vault.packaging.registry.impl.FSPackageRegistry");
            registrycfg.getProperties().put("homePath", registryHome.getPath());
            context.addConfiguration(registrycfg.getPid(), null, registrycfg.getProperties());
            return true;
        }
        return false;
    }

    private File getRegistryHomeDir(ExtensionContext context) {
        File registryHome;
        String registryPath = System.getProperty(PACKAGEREGISTRY_HOME);
        if (registryPath != null) {
            registryHome = Paths.get(registryPath, new String[0]).toFile();
        } else {
            String repoHome = (String)context.getFrameworkProperties().get(REPOSITORY_HOME);
            if (repoHome == null) {
                throw new IllegalStateException("Neither registry.home set nor repository.home configured.");
            }
            registryHome = Paths.get(repoHome, REGISTRY_FOLDER).toFile();
        }
        if (!registryHome.exists()) {
            registryHome.mkdirs();
        }
        if (!registryHome.isDirectory()) {
            throw new IllegalStateException("Registry but points to file - must be directory");
        }
        return registryHome;
    }
}

