/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config;

import java.io.IOException;
import java.util.ArrayList;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.sling.feature.extension.apiregions.api.config.AttributeableEntity;

public class PropertyDescriptionAddition
extends AttributeableEntity {
    private String[] includes;

    public PropertyDescriptionAddition() {
        this.setDefaults();
    }

    @Override
    public void clear() {
        super.clear();
        this.setIncludes(null);
    }

    @Override
    public void fromJSONObject(JsonObject jsonObj) throws IOException {
        super.fromJSONObject(jsonObj);
        try {
            JsonValue incs = this.getAttributes().remove("includes");
            if (incs != null) {
                ArrayList<String> list = new ArrayList<String>();
                for (JsonValue innerVal : incs.asJsonArray()) {
                    list.add(this.getString(innerVal));
                }
                this.setIncludes(list.toArray(new String[list.size()]));
            }
        }
        catch (IllegalArgumentException | JsonException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected JsonObjectBuilder createJson() throws IOException {
        JsonObjectBuilder objectBuilder = super.createJson();
        if (this.getIncludes() != null && this.getIncludes().length > 0) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String v : this.getIncludes()) {
                arrayBuilder.add(v);
            }
            objectBuilder.add("includes", arrayBuilder);
        }
        return objectBuilder;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }
}

