/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.HandlerContext;
import org.apache.sling.feature.builder.MergeHandler;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurableEntityAddition;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationApi;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationDescriptionAddition;
import org.apache.sling.feature.extension.apiregions.api.config.DescribableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.FactoryConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.FactoryConfigurationDescriptionAddition;
import org.apache.sling.feature.extension.apiregions.api.config.FrameworkPropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyDescriptionAddition;
import org.apache.sling.feature.extension.apiregions.api.config.Region;

public class ConfigurationApiMergeHandler
implements MergeHandler {
    public boolean canMerge(Extension extension) {
        return "configuration-api".equals(extension.getName());
    }

    public void merge(HandlerContext context, Feature targetFeature, Feature sourceFeature, Extension targetExtension, Extension sourceExtension) {
        if (targetExtension == null) {
            ConfigurationApi sourceApi = ConfigurationApi.getConfigurationApi(sourceExtension);
            sourceApi.getFeatureToRegionCache().put(sourceFeature.getId(), sourceApi.detectRegion());
            ConfigurationApi.setConfigurationApi(targetFeature, sourceApi);
        } else {
            ConfigurationApi sourceApi = ConfigurationApi.getConfigurationApi(sourceExtension);
            ConfigurationApi targetApi = ConfigurationApi.getConfigurationApi(targetExtension);
            if (context.isInitialMerge()) {
                targetApi.setRegion(sourceApi.getRegion());
                targetApi.setMode(sourceApi.getMode());
            } else {
                if (sourceApi.getRegion() != targetApi.getRegion()) {
                    if (context.isPrototypeMerge()) {
                        if (sourceApi.getRegion() != null) {
                            targetApi.setRegion(sourceApi.getRegion());
                        }
                    } else {
                        targetApi.setRegion(Region.GLOBAL);
                    }
                }
                if (targetApi.getMode().ordinal() > sourceApi.getMode().ordinal()) {
                    targetApi.setMode(sourceApi.getMode());
                }
            }
            for (Map.Entry<String, ConfigurationDescription> entry : sourceApi.getConfigurationDescriptions().entrySet()) {
                if (targetApi.getConfigurationDescriptions().containsKey(entry.getKey())) {
                    throw new IllegalStateException("Duplicate configuration description " + entry.getKey());
                }
                targetApi.getConfigurationDescriptions().put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, ConfigurableEntity> entry : sourceApi.getFactoryConfigurationDescriptions().entrySet()) {
                if (targetApi.getFactoryConfigurationDescriptions().containsKey(entry.getKey())) {
                    throw new IllegalStateException("Duplicate factory configuration description " + entry.getKey());
                }
                targetApi.getFactoryConfigurationDescriptions().put(entry.getKey(), (FactoryConfigurationDescription)entry.getValue());
            }
            for (Map.Entry<String, DescribableEntity> entry : sourceApi.getFrameworkPropertyDescriptions().entrySet()) {
                if (targetApi.getFrameworkPropertyDescriptions().containsKey(entry.getKey())) {
                    throw new IllegalStateException("Duplicate framework property description " + entry.getKey());
                }
                targetApi.getFrameworkPropertyDescriptions().put(entry.getKey(), (FrameworkPropertyDescription)entry.getValue());
            }
            targetApi.getInternalConfigurations().addAll(sourceApi.getInternalConfigurations());
            targetApi.getInternalFactoryConfigurations().addAll(sourceApi.getInternalFactoryConfigurations());
            targetApi.getInternalFrameworkProperties().addAll(sourceApi.getInternalFrameworkProperties());
            if (!context.isPrototypeMerge()) {
                targetApi.getFeatureToRegionCache().put(sourceFeature.getId(), sourceApi.detectRegion());
                targetApi.getFeatureToRegionCache().putAll(sourceApi.getFeatureToRegionCache());
            }
            this.processAdditions(targetApi, targetApi, false);
            this.processAdditions(targetApi, sourceApi, true);
            ConfigurationApi.setConfigurationApi(targetFeature, targetApi);
        }
    }

    private void processAdditions(ConfigurationApi targetApi, ConfigurationApi sourceApi, boolean keep) {
        Iterator<Map.Entry<String, ConfigurationDescriptionAddition>> itc = sourceApi.getConfigurationDescriptionAdditions().entrySet().iterator();
        while (itc.hasNext()) {
            Map.Entry<String, ConfigurationDescriptionAddition> entry = itc.next();
            ConfigurationDescription cd = targetApi.getConfigurationDescriptions().get(entry.getKey());
            if (cd == null && keep) {
                if (targetApi.getConfigurationDescriptionAdditions().get(entry.getKey()) == null) {
                    targetApi.getConfigurationDescriptionAdditions().put(entry.getKey(), entry.getValue());
                    continue;
                }
                throw new IllegalStateException("Duplicate configuration description addition " + entry.getKey());
            }
            if (cd == null) continue;
            this.processAddition("configuration ".concat(entry.getKey()), cd, entry.getValue());
            if (keep) continue;
            itc.remove();
        }
        Iterator<Map.Entry<String, FactoryConfigurationDescriptionAddition>> itf = sourceApi.getFactoryConfigurationDescriptionAdditions().entrySet().iterator();
        while (itf.hasNext()) {
            Map.Entry<String, FactoryConfigurationDescriptionAddition> entry = itf.next();
            FactoryConfigurationDescription cd = targetApi.getFactoryConfigurationDescriptions().get(entry.getKey());
            if (cd == null && keep) {
                if (targetApi.getFactoryConfigurationDescriptionAdditions().get(entry.getKey()) == null) {
                    targetApi.getFactoryConfigurationDescriptionAdditions().put(entry.getKey(), entry.getValue());
                    continue;
                }
                throw new IllegalStateException("Duplicate factory configuration description addition " + entry.getKey());
            }
            if (cd == null) continue;
            this.processAddition("factory configuration ".concat(entry.getKey()), cd, entry.getValue());
            if (keep) continue;
            itf.remove();
        }
    }

    private void processAddition(String descId, ConfigurableEntity entity, ConfigurableEntityAddition addition) {
        for (Map.Entry<String, PropertyDescriptionAddition> entry : addition.getPropertyDescriptionAdditions().entrySet()) {
            String propName = entry.getKey();
            PropertyDescription pd = entity.getPropertyDescriptions().get(propName);
            if (pd == null) {
                throw new IllegalStateException("Property named '" + propName + "' is not defined in " + descId);
            }
            if (entry.getValue().getIncludes() == null) continue;
            LinkedHashSet<String> includes = new LinkedHashSet<String>();
            if (pd.getIncludes() != null) {
                for (String v : pd.getIncludes()) {
                    includes.add(v);
                }
            }
            for (String v : entry.getValue().getIncludes()) {
                includes.add(v);
            }
            pd.setIncludes(includes.toArray(new String[includes.size()]));
        }
        if (entity instanceof FactoryConfigurationDescription) {
            FactoryConfigurationDescription fcd = (FactoryConfigurationDescription)entity;
            FactoryConfigurationDescriptionAddition fcda = (FactoryConfigurationDescriptionAddition)addition;
            for (String n : fcda.getInternalNames()) {
                fcd.getInternalNames().add(n);
            }
        }
    }
}

