/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions;

import java.util.Map;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.HandlerContext;
import org.apache.sling.feature.builder.MergeHandler;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationApi;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.DescribableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.FactoryConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.FrameworkPropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.Region;

public class ConfigurationApiMergeHandler
implements MergeHandler {
    public boolean canMerge(Extension extension) {
        return "configuration-api".equals(extension.getName());
    }

    public void merge(HandlerContext context, Feature targetFeature, Feature sourceFeature, Extension targetExtension, Extension sourceExtension) {
        if (targetExtension == null) {
            ConfigurationApi sourceApi = ConfigurationApi.getConfigurationApi(sourceExtension);
            sourceApi.getFeatureToRegionCache().put(sourceFeature.getId(), sourceApi.detectRegion());
            ConfigurationApi.setConfigurationApi(targetFeature, sourceApi);
        } else {
            ConfigurationApi sourceApi = ConfigurationApi.getConfigurationApi(sourceExtension);
            ConfigurationApi targetApi = ConfigurationApi.getConfigurationApi(targetExtension);
            if (context.isInitialMerge()) {
                targetApi.setRegion(sourceApi.getRegion());
                targetApi.setMode(sourceApi.getMode());
            } else {
                if (sourceApi.getRegion() != targetApi.getRegion()) {
                    if (context.isPrototypeMerge()) {
                        if (sourceApi.getRegion() != null) {
                            targetApi.setRegion(sourceApi.getRegion());
                        }
                    } else {
                        targetApi.setRegion(Region.GLOBAL);
                    }
                }
                if (targetApi.getMode().ordinal() > sourceApi.getMode().ordinal()) {
                    targetApi.setMode(sourceApi.getMode());
                }
            }
            for (Map.Entry<String, ConfigurationDescription> entry : sourceApi.getConfigurationDescriptions().entrySet()) {
                if (targetApi.getConfigurationDescriptions().containsKey(entry.getKey())) {
                    throw new IllegalStateException("Duplicate configuration description " + entry.getKey());
                }
                targetApi.getConfigurationDescriptions().put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, ConfigurableEntity> entry : sourceApi.getFactoryConfigurationDescriptions().entrySet()) {
                if (targetApi.getFactoryConfigurationDescriptions().containsKey(entry.getKey())) {
                    throw new IllegalStateException("Duplicate factory configuration description " + entry.getKey());
                }
                targetApi.getFactoryConfigurationDescriptions().put(entry.getKey(), (FactoryConfigurationDescription)entry.getValue());
            }
            for (Map.Entry<String, DescribableEntity> entry : sourceApi.getFrameworkPropertyDescriptions().entrySet()) {
                if (targetApi.getFrameworkPropertyDescriptions().containsKey(entry.getKey())) {
                    throw new IllegalStateException("Duplicate framework property description " + entry.getKey());
                }
                targetApi.getFrameworkPropertyDescriptions().put(entry.getKey(), (FrameworkPropertyDescription)entry.getValue());
            }
            targetApi.getInternalConfigurations().addAll(sourceApi.getInternalConfigurations());
            targetApi.getInternalFactoryConfigurations().addAll(sourceApi.getInternalFactoryConfigurations());
            targetApi.getInternalFrameworkProperties().addAll(sourceApi.getInternalFrameworkProperties());
            if (!context.isPrototypeMerge()) {
                targetApi.getFeatureToRegionCache().put(sourceFeature.getId(), sourceApi.detectRegion());
                targetApi.getFeatureToRegionCache().putAll(sourceApi.getFeatureToRegionCache());
            }
            ConfigurationApi.setConfigurationApi(targetFeature, targetApi);
        }
    }
}

