/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonStructure;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.HandlerContext;
import org.apache.sling.feature.builder.MergeHandler;
import org.apache.sling.feature.extension.apiregions.api.ApiExport;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;

public class APIRegionMergeHandler
implements MergeHandler {
    public boolean canMerge(Extension extension) {
        return "api-regions".equals(extension.getName());
    }

    public void merge(HandlerContext context, Feature target, Feature source, Extension targetEx, Extension sourceEx) {
        if (!sourceEx.getName().equals("api-regions")) {
            return;
        }
        if (targetEx != null && !targetEx.getName().equals("api-regions")) {
            return;
        }
        try {
            ApiRegions targetRegions;
            ApiRegions srcRegions = ApiRegions.parse((JsonArray)sourceEx.getJSONStructure());
            if (targetEx != null) {
                targetRegions = ApiRegions.parse((JsonArray)targetEx.getJSONStructure());
            } else {
                targetEx = new Extension(sourceEx.getType(), sourceEx.getName(), sourceEx.getState());
                target.getExtensions().add((Object)targetEx);
                targetRegions = new ApiRegions();
            }
            for (ApiRegion targetRegion : targetRegions.listRegions()) {
                ApiRegion sourceRegion = srcRegions.getRegionByName(targetRegion.getName());
                if (sourceRegion == null) continue;
                for (ApiExport srcExp : sourceRegion.listExports()) {
                    if (targetRegion.getExportByName(srcExp.getName()) != null) continue;
                    targetRegion.add(srcExp);
                }
                LinkedHashSet<ArtifactId> targetOrigins = new LinkedHashSet<ArtifactId>(Arrays.asList(targetRegion.getFeatureOrigins()));
                LinkedHashSet<ArtifactId> sourceOrigins = new LinkedHashSet<ArtifactId>(Arrays.asList(sourceRegion.getFeatureOrigins()));
                if (sourceOrigins.isEmpty()) {
                    sourceOrigins.add(source.getId());
                }
                targetOrigins.addAll(sourceOrigins);
                targetRegion.setFeatureOrigins(targetOrigins.toArray(new ArtifactId[0]));
            }
            HashMap<String, Integer> regionPos = new HashMap<String, Integer>();
            List<ApiRegion> tRegions = targetRegions.listRegions();
            for (int i = 0; i < tRegions.size(); ++i) {
                regionPos.put(tRegions.get(i).getName(), i);
            }
            List<ApiRegion> sRegions = srcRegions.listRegions();
            int nextInsertPosition = tRegions.size();
            String nextFound = this.getNextFound(sRegions.size() - 1, regionPos, sRegions);
            for (int i = sRegions.size() - 1; i >= 0; --i) {
                ApiRegion cur = sRegions.get(i);
                if (cur.getName().equals(nextFound)) {
                    nextFound = this.getNextFound(i - 1, regionPos, sRegions);
                    if (nextFound == null) {
                        nextInsertPosition = 0;
                        continue;
                    }
                    nextInsertPosition = (Integer)regionPos.get(nextFound) + 1;
                    continue;
                }
                LinkedHashSet<ArtifactId> origins = new LinkedHashSet<ArtifactId>(Arrays.asList(cur.getFeatureOrigins()));
                if (origins.isEmpty()) {
                    origins.add(source.getId());
                    cur.setFeatureOrigins(origins.toArray(new ArtifactId[0]));
                }
                if (targetRegions.add(nextInsertPosition, cur)) continue;
                throw new IllegalStateException("Duplicate region " + cur.getName());
            }
            targetEx.setJSONStructure((JsonStructure)targetRegions.toJSONArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getNextFound(int startPos, Map<String, Integer> regionPos, List<ApiRegion> sourceRegions) {
        for (int i = startPos; i >= 0; --i) {
            String name = sourceRegions.get(i).getName();
            if (regionPos.get(name) == null) continue;
            return name;
        }
        return null;
    }
}

