/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.felix.cm.json.Configurations;
import org.apache.sling.feature.extension.apiregions.api.config.DescribableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.Mode;
import org.apache.sling.feature.extension.apiregions.api.config.Option;
import org.apache.sling.feature.extension.apiregions.api.config.PlaceholderPolicy;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyType;
import org.apache.sling.feature.extension.apiregions.api.config.Range;

public class PropertyDescription
extends DescribableEntity {
    private PropertyType type;
    private int cardinality;
    private String variable;
    private Range range;
    private String[] includes;
    private String[] excludes;
    private List<Option> options;
    private Pattern pattern;
    private boolean required;
    private Object defaultValue;
    private Mode mode;
    private PlaceholderPolicy placeholderPolicy;
    private Pattern placeholderPattern;

    public PropertyDescription() {
        this.setDefaults();
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        this.setType(PropertyType.STRING);
        this.setCardinality(1);
        this.setRequired(false);
        this.setPlaceholderPolicy(PlaceholderPolicy.DEFAULT);
    }

    @Override
    public void clear() {
        super.clear();
        this.setVariable(null);
        this.setRange(null);
        this.setIncludes(null);
        this.setExcludes(null);
        this.setOptions(null);
        this.setRegex(null);
        this.setDefaultValue(null);
        this.setMode(null);
    }

    @Override
    public void fromJSONObject(JsonObject jsonObj) throws IOException {
        super.fromJSONObject(jsonObj);
        try {
            String policyVal;
            String modeVal;
            JsonValue opts;
            JsonValue excs;
            JsonValue incs;
            JsonValue rangeVal;
            this.setVariable(this.getString("variable"));
            this.setCardinality(this.getInteger("cardinality", this.getCardinality()));
            this.setRequired(this.getBoolean("required", this.isRequired()));
            String typeVal = this.getString("type");
            if (typeVal != null) {
                this.setType(PropertyType.valueOf(typeVal.toUpperCase()));
            }
            if ((rangeVal = this.getAttributes().remove("range")) != null) {
                Range range = new Range();
                range.fromJSONObject(rangeVal.asJsonObject());
                this.setRange(range);
            }
            if ((incs = this.getAttributes().remove("includes")) != null) {
                ArrayList<String> list = new ArrayList<String>();
                for (Object innerVal : incs.asJsonArray()) {
                    list.add(this.getString((JsonValue)innerVal));
                }
                this.setIncludes(list.toArray(new String[list.size()]));
            }
            if ((excs = this.getAttributes().remove("excludes")) != null) {
                ArrayList<String> list = new ArrayList<String>();
                for (Object innerVal : excs.asJsonArray()) {
                    list.add(this.getString((JsonValue)innerVal));
                }
                this.setExcludes(list.toArray(new String[list.size()]));
            }
            if ((opts = this.getAttributes().remove("options")) != null) {
                ArrayList<Option> list = new ArrayList<Option>();
                for (JsonValue innerVal : opts.asJsonArray()) {
                    Option o = new Option();
                    o.fromJSONObject(innerVal.asJsonObject());
                    list.add(o);
                }
                this.setOptions(list);
            }
            this.setRegex(this.getString("regex"));
            JsonValue dv = this.getAttributes().remove("default");
            if (dv != null) {
                this.setDefaultValue(Configurations.convertToObject((JsonValue)dv));
            }
            if ((modeVal = this.getString("mode")) != null) {
                this.setMode(Mode.valueOf(modeVal.toUpperCase()));
            }
            if ((policyVal = this.getString("placeholder-policy")) != null) {
                this.setPlaceholderPolicy(PlaceholderPolicy.valueOf(policyVal.toUpperCase()));
            }
            this.setPlaceholderRegex(this.getString("placeholder-regex"));
        }
        catch (IllegalArgumentException | JsonException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected JsonObjectBuilder createJson() throws IOException {
        JsonArrayBuilder arrayBuilder;
        JsonObjectBuilder objectBuilder = super.createJson();
        if (this.getType() != null && this.getType() != PropertyType.STRING) {
            this.setString(objectBuilder, "type", this.getType().name());
        }
        if (this.getCardinality() != 1) {
            objectBuilder.add("cardinality", this.getCardinality());
        }
        if (this.isRequired()) {
            objectBuilder.add("required", this.isRequired());
        }
        this.setString(objectBuilder, "variable", this.getVariable());
        if (this.getRange() != null) {
            objectBuilder.add("range", (JsonValue)this.getRange().toJSONObject());
        }
        if (this.getIncludes() != null && this.getIncludes().length > 0) {
            arrayBuilder = Json.createArrayBuilder();
            for (String string : this.getIncludes()) {
                arrayBuilder.add(string);
            }
            objectBuilder.add("includes", arrayBuilder);
        }
        if (this.getExcludes() != null && this.getExcludes().length > 0) {
            arrayBuilder = Json.createArrayBuilder();
            for (String string : this.getExcludes()) {
                arrayBuilder.add(string);
            }
            objectBuilder.add("excludes", arrayBuilder);
        }
        if (this.getOptions() != null && !this.getOptions().isEmpty()) {
            arrayBuilder = Json.createArrayBuilder();
            for (Option o : this.getOptions()) {
                arrayBuilder.add((JsonValue)o.toJSONObject());
            }
            objectBuilder.add("options", arrayBuilder);
        }
        this.setString(objectBuilder, "regex", this.getRegex());
        if (this.getDefaultValue() != null) {
            objectBuilder.add("default", Configurations.convertToJsonValue((Object)this.getDefaultValue()));
        }
        if (this.getMode() != null) {
            objectBuilder.add("mode", this.getMode().name());
        }
        if (this.getPlaceholderPolicy() != PlaceholderPolicy.DEFAULT) {
            objectBuilder.add("placeholder-policy", this.getPlaceholderPolicy().name());
        }
        this.setString(objectBuilder, "placeholder-regex", this.getPlaceholderRegex());
        return objectBuilder;
    }

    public PropertyType getType() {
        return this.type;
    }

    public void setType(PropertyType type) {
        this.type = type == null ? PropertyType.STRING : type;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int value) {
        if (value == 0 || value < -1) {
            throw new IllegalArgumentException();
        }
        this.cardinality = value;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public String getRegex() {
        return this.pattern == null ? null : this.pattern.pattern();
    }

    public void setRegex(String regex) {
        this.pattern = regex == null ? null : Pattern.compile(regex);
    }

    public Pattern getRegexPattern() {
        return this.pattern;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean flag) {
        this.required = flag;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object val) {
        this.defaultValue = val;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode value) {
        this.mode = value;
    }

    public PlaceholderPolicy getPlaceholderPolicy() {
        return this.placeholderPolicy;
    }

    public void setPlaceholderPolicy(PlaceholderPolicy policy) {
        this.placeholderPolicy = policy == null ? PlaceholderPolicy.DEFAULT : policy;
    }

    public String getPlaceholderRegex() {
        return this.placeholderPattern == null ? null : this.placeholderPattern.pattern();
    }

    public void setPlaceholderRegex(String regex) {
        this.placeholderPattern = regex == null ? null : Pattern.compile(regex);
    }

    public Pattern getPlaceholderRegexPattern() {
        return this.placeholderPattern;
    }
}

