/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.diff.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import javax.json.Json;
import javax.json.JsonValue;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.diff.impl.AbstractFeatureElementComparator;

public final class ExtensionsComparator
extends AbstractFeatureElementComparator {
    public ExtensionsComparator() {
        super("extensions");
    }

    @Override
    public void computeDiff(Feature previous, Feature current, Feature target) {
        this.computeDiff(previous.getExtensions(), current.getExtensions(), target);
    }

    protected void computeDiff(Extensions previousExtensions, Extensions currentExtensions, Feature target) {
        for (Extension previousExtension : previousExtensions) {
            Extension currentExtension = currentExtensions.getByName(previousExtension.getName());
            if (currentExtension == null) {
                target.getPrototype().getExtensionRemovals().add(previousExtension.getName());
                continue;
            }
            this.computeDiff(previousExtension, currentExtension, target);
        }
        for (Extension currentExtension : currentExtensions) {
            Extension previousConfiguration = previousExtensions.getByName(currentExtension.getName());
            if (previousConfiguration != null) continue;
            target.getExtensions().add((Object)currentExtension);
        }
    }

    protected void computeDiff(Extension previousExtension, Extension currentExtension, Feature target) {
        boolean replace = false;
        switch (previousExtension.getType()) {
            case ARTIFACTS: {
                Extension targetExtension = new Extension(previousExtension.getType(), previousExtension.getName(), previousExtension.isRequired());
                for (Artifact previous : previousExtension.getArtifacts()) {
                    Artifact current = currentExtension.getArtifacts().getSame(previous.getId());
                    boolean add = false;
                    if (current == null || (add = !previous.getId().equals((Object)current.getId()))) {
                        target.getPrototype().getArtifactExtensionRemovals().computeIfAbsent(previousExtension.getName(), k -> new LinkedList()).add(previous.getId());
                    }
                    if (!add) continue;
                    targetExtension.getArtifacts().add(current);
                }
                for (Artifact current : currentExtension.getArtifacts()) {
                    Artifact previous = previousExtension.getArtifacts().getSame(current.getId());
                    if (previous != null) continue;
                    targetExtension.getArtifacts().add(current);
                }
                if (targetExtension.getArtifacts().isEmpty()) break;
                target.getExtensions().add((Object)targetExtension);
                break;
            }
            case TEXT: {
                if (previousExtension.getText().equals(currentExtension.getText())) break;
                replace = true;
                break;
            }
            case JSON: {
                String previousJSON = previousExtension.getJSON();
                String currentJSON = currentExtension.getJSON();
                try {
                    JsonValue previousNode = ExtensionsComparator.parseJSON(previousJSON);
                    JsonValue currentNode = ExtensionsComparator.parseJSON(currentJSON);
                    if (previousNode.equals(currentNode)) break;
                    replace = true;
                    break;
                }
                catch (Throwable t) {
                    throw new RuntimeException("A JSON parse error occurred while parsing previous '" + previousJSON + "' and current '" + currentJSON + "', see nested errors:", t);
                }
            }
        }
        if (replace) {
            target.getPrototype().getExtensionRemovals().add(currentExtension.getName());
            target.getExtensions().add((Object)currentExtension);
        }
    }

    private static JsonValue parseJSON(String json) {
        return Json.createReader((Reader)new StringReader(json)).read();
    }
}

