/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingNameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.io.DocViewParserHandler;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.apache.jackrabbit.vault.util.RejectingEntityDefaultHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class DocViewSAXHandler
extends RejectingEntityDefaultHandler
implements NamespaceResolver {
    private static final NameFactory FACTORY = NameFactoryImpl.getInstance();
    static final Logger log = LoggerFactory.getLogger(DocViewSAXHandler.class);
    static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    private final NamespaceSupport nsSupport;
    private final NameResolver nameResolver;
    @Nullable
    private final NamespaceResolver nsResolver;
    private final DocViewParserHandler handler;
    private final String rootNodePath;
    private final Deque<DocViewNode2> nodeStack;
    private String currentPath;
    private Locator locator;

    public DocViewSAXHandler(@NotNull DocViewParserHandler handler, @NotNull String rootNodePath, @Nullable NamespaceResolver nsResolver) {
        Objects.requireNonNull(handler, "handler must not be null");
        this.handler = handler;
        Objects.requireNonNull(rootNodePath, "rootNodePath must not be null");
        if (rootNodePath.isEmpty()) {
            throw new IllegalArgumentException("rootNodePath must not be empty");
        }
        this.rootNodePath = rootNodePath;
        this.nsSupport = new NamespaceSupport();
        this.nodeStack = new LinkedList<DocViewNode2>();
        this.currentPath = null;
        this.locator = new LocatorImpl();
        this.nsResolver = nsResolver;
        this.nameResolver = new ParsingNameResolver(NameFactoryImpl.getInstance(), (NamespaceResolver)this);
    }

    @Override
    public void startDocument() throws SAXException {
        this.handler.setNameResolver(this.nameResolver);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @NotNull
    public Locator getDocumentLocator() {
        return this.locator;
    }

    @NotNull
    public String getCurrentPath() {
        return this.currentPath != null ? this.currentPath : this.rootNodePath;
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.handler.endDocument();
        }
        catch (IOException | RepositoryException e) {
            throw new SAXException((Exception)e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        log.trace("-> prefixMapping for {}:{}", (Object)prefix, (Object)uri);
        this.nsSupport.pushContext();
        this.nsSupport.declarePrefix(prefix, uri);
        this.handler.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        log.trace("<- prefixMapping for {}", (Object)prefix);
        this.nsSupport.popContext();
        this.handler.endPrefixMapping(prefix);
    }

    private Map.Entry<String, Integer> getNameAndIndex(String name) {
        int idx = name.lastIndexOf(91);
        int index = 0;
        if (idx > 0) {
            int idx2 = name.indexOf(93, idx);
            if (idx2 > 0) {
                try {
                    index = Integer.valueOf(name.substring(idx + 1, idx2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            name = name.substring(0, idx);
        }
        return new AbstractMap.SimpleEntry<String, Integer>(name, index);
    }

    public String getURI(String prefix) throws NamespaceException {
        if (prefix.equals("")) {
            return "";
        }
        String uri = this.nsSupport.getURI(prefix);
        if (uri == null) {
            if (this.nsResolver != null) {
                return this.nsResolver.getURI(prefix);
            }
            throw new NamespaceException("Unknown prefix " + prefix);
        }
        return uri;
    }

    public String getPrefix(String uri) throws NamespaceException {
        String prefix = this.nsSupport.getPrefix(uri);
        if (prefix == null) {
            if (this.nsResolver != null) {
                return this.nsResolver.getPrefix(uri);
            }
            throw new NamespaceException("Unmapped URL " + uri);
        }
        return prefix;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Map.Entry<String, Integer> nameAndIndex;
        int index;
        Name name;
        log.trace("-> element {}", (Object)qName);
        if (this.currentPath == null && localName.equals(NameConstants.JCR_ROOT.getLocalName()) && uri.equals(NameConstants.JCR_ROOT.getNamespaceURI())) {
            if (this.rootNodePath.equals("/")) {
                name = NameConstants.ROOT;
                index = 0;
            } else {
                nameAndIndex = this.getNameAndIndex(Text.getName((String)this.rootNodePath));
                index = nameAndIndex.getValue();
                try {
                    name = this.nameResolver.getQName(nameAndIndex.getKey());
                }
                catch (NamespaceException e) {
                    throw new SAXException("Unknown namespace prefix used in file name '" + nameAndIndex.getKey() + "'", (Exception)((Object)e));
                }
                catch (IllegalNameException e) {
                    throw new SAXException("Invalid name format used in file name '" + nameAndIndex.getKey() + "'", (Exception)((Object)e));
                }
            }
            this.currentPath = this.rootNodePath;
        } else {
            nameAndIndex = this.getNameAndIndex(ISO9075.decode((String)localName));
            index = nameAndIndex.getValue();
            try {
                name = FACTORY.create(uri, nameAndIndex.getKey());
                if (this.currentPath == null) {
                    this.currentPath = Text.getRelativeParent((String)this.rootNodePath, (int)1);
                }
                this.currentPath = PathUtil.append(this.currentPath, ISO9075.decode((String)qName));
            }
            catch (IllegalArgumentException e) {
                throw new SAXException("Invalid name format used in node name '" + nameAndIndex.getKey() + "'", e);
            }
        }
        try {
            ArrayList<DocViewProperty2> props = new ArrayList<DocViewProperty2>(attributes.getLength());
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getType(i).equals("CDATA")) continue;
                Name pName = FACTORY.create(attributes.getURI(i), ISO9075.decode((String)attributes.getLocalName(i)));
                DocViewProperty2 property = DocViewProperty2.parse(pName, attributes.getValue(i));
                props.add(property);
            }
            DocViewNode2 ni = new DocViewNode2(name, index, props);
            this.handler.startDocViewNode(this.currentPath, ni, Optional.ofNullable(this.nodeStack.peek()), this.locator.getLineNumber(), this.locator.getColumnNumber());
            this.nodeStack.push(ni);
        }
        catch (IOException | RepositoryException e) {
            throw new SAXException("Error while processing element " + qName, (Exception)e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        log.trace("<- element {}", (Object)qName);
        try {
            this.currentPath = Text.getRelativeParent((String)this.currentPath, (int)1);
            this.handler.endDocViewNode(this.currentPath, this.nodeStack.pop(), Optional.ofNullable(this.nodeStack.peek()), this.locator.getLineNumber(), this.locator.getColumnNumber());
        }
        catch (IOException | RepositoryException e) {
            throw new SAXException((Exception)e);
        }
    }

    public static final class Namespace {
        public Namespace next = null;
        public String prefix;
        public String uri;

        public Namespace(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }
    }
}

