/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.xml.Importer;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

abstract class TargetImportHandler
extends DefaultHandler {
    private static Logger log = LoggerFactory.getLogger(TargetImportHandler.class);
    protected final Importer importer;
    protected final NamePathResolver resolver;

    protected TargetImportHandler(Importer importer, NamePathResolver resolver) {
        this.importer = importer;
        this.resolver = resolver;
    }

    protected void disposePropertyValues(Importer.PropInfo prop) {
        Importer.TextValue[] vals = prop.getValues();
        for (int i = 0; i < vals.length; ++i) {
            if (!(vals[i] instanceof AppendableValue)) continue;
            try {
                ((AppendableValue)vals[i]).dispose();
                continue;
            }
            catch (IOException ioe) {
                log.warn("error while disposing temporary value", (Throwable)ioe);
            }
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.importer.start();
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.importer.end();
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    protected class BufferedStringValue
    implements AppendableValue {
        private static final int MAX_BUFFER_SIZE = 65536;
        private static final int BUFFER_INCREMENT = 8192;
        private char[] buffer = new char[8192];
        private int bufferPos = 0;
        private File tmpFile = null;
        private Writer writer = null;

        protected BufferedStringValue() {
        }

        @Override
        public long length() throws IOException {
            if (this.buffer != null) {
                return this.bufferPos;
            }
            if (this.tmpFile != null) {
                this.writer.flush();
                return this.tmpFile.length();
            }
            throw new IOException("this instance has already been disposed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String retrieve() throws IOException {
            if (this.buffer != null) {
                return new String(this.buffer, 0, this.bufferPos);
            }
            if (this.tmpFile != null) {
                this.writer.flush();
                if (this.tmpFile.length() > Integer.MAX_VALUE) {
                    throw new IOException("size of value is too big, use reader()");
                }
                StringBuffer sb = new StringBuffer((int)this.tmpFile.length());
                char[] chunk = new char[8192];
                try (FileReader reader = new FileReader(this.tmpFile);){
                    int read;
                    while ((read = reader.read(chunk)) > -1) {
                        sb.append(chunk, 0, read);
                    }
                }
                return sb.toString();
            }
            throw new IOException("this instance has already been disposed");
        }

        @Override
        public Reader reader() throws IOException {
            if (this.buffer != null) {
                return new StringReader(new String(this.buffer, 0, this.bufferPos));
            }
            if (this.tmpFile != null) {
                this.writer.flush();
                return new FileReader(this.tmpFile);
            }
            throw new IOException("this instance has already been disposed");
        }

        @Override
        public void append(char[] chars, int start, int length) throws IOException {
            if (this.buffer != null) {
                if (this.bufferPos + length > 65536) {
                    TransientFileFactory fileFactory = TransientFileFactory.getInstance();
                    this.tmpFile = fileFactory.createTransientFile("txt", null, null);
                    final FileOutputStream fout = new FileOutputStream(this.tmpFile);
                    this.writer = new OutputStreamWriter(fout){

                        @Override
                        public void flush() throws IOException {
                            super.flush();
                            fout.getFD().sync();
                        }
                    };
                    this.writer.write(this.buffer, 0, this.bufferPos);
                    this.writer.write(chars, start, length);
                    this.buffer = null;
                    this.bufferPos = 0;
                } else {
                    if (this.bufferPos + length > this.buffer.length) {
                        char[] newBuffer = new char[this.bufferPos + length + 8192];
                        System.arraycopy(this.buffer, 0, newBuffer, 0, this.bufferPos);
                        this.buffer = newBuffer;
                    }
                    System.arraycopy(chars, start, this.buffer, this.bufferPos, length);
                    this.bufferPos += length;
                }
            } else if (this.tmpFile != null) {
                this.writer.write(chars, start, length);
            } else {
                throw new IOException("this instance has already been disposed");
            }
        }

        @Override
        public void close() throws IOException {
            if (this.buffer == null) {
                if (this.tmpFile != null) {
                    this.writer.close();
                } else {
                    throw new IOException("this instance has already been disposed");
                }
            }
        }

        @Override
        public void dispose() throws IOException {
            if (this.buffer != null) {
                this.buffer = null;
                this.bufferPos = 0;
            } else if (this.tmpFile != null) {
                this.writer.close();
                this.tmpFile.delete();
                this.tmpFile = null;
                this.writer = null;
            } else {
                throw new IOException("this instance has already been disposed");
            }
        }
    }

    protected class StringValue
    implements Importer.TextValue {
        private final String value;

        protected StringValue(String value) {
            this.value = value;
        }

        @Override
        public long length() {
            return this.value.length();
        }

        @Override
        public String retrieve() {
            return this.value;
        }

        @Override
        public Reader reader() {
            return new StringReader(this.value);
        }
    }

    public static interface AppendableValue
    extends Importer.TextValue {
        public void append(char[] var1, int var2, int var3) throws IOException;

        public void close() throws IOException;

        public void dispose() throws IOException;
    }
}

