/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation;

import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValidationViolation
extends ValidationMessage {
    private final String validatorId;

    public static final Collection<ValidationViolation> wrapMessages(String validatorId, Collection<? extends ValidationMessage> messages, Path filePath, Path basePath, String nodePath, int line, int column) {
        LinkedList<ValidationViolation> violations = new LinkedList<ValidationViolation>();
        for (ValidationMessage validationMessage : messages) {
            violations.add(ValidationViolation.wrapMessage(validatorId, validationMessage, filePath, basePath, nodePath, line, column));
        }
        return violations;
    }

    public static final ValidationViolation wrapMessage(String validatorId, ValidationMessage message, Path filePath, Path basePath, String nodePath, int line, int column) {
        if (message instanceof ValidationViolation) {
            ValidationViolation delegate = (ValidationViolation)ValidationViolation.class.cast(message);
            return new ValidationViolation(delegate.validatorId != null ? delegate.validatorId : validatorId, delegate, delegate.getFilePath() != null ? delegate.getFilePath() : filePath, delegate.getBasePath() != null ? delegate.getBasePath() : basePath, delegate.getNodePath() != null ? delegate.getNodePath() : nodePath, delegate.getLine() != 0 ? delegate.getLine() : line, delegate.getColumn() != 0 ? delegate.getColumn() : column, delegate.getThrowable());
        }
        return new ValidationViolation(validatorId, message, filePath, basePath, nodePath, line, column, message.getThrowable());
    }

    ValidationViolation(String validatorId, ValidationMessage message, Path filePath, Path basePath, String nodePath, int line, int column, Throwable t) {
        super(message.getSeverity(), message.getMessage(), message.getNodePath() != null ? message.getNodePath() : nodePath, message.getFilePath() != null ? message.getFilePath() : filePath, message.getBasePath() != null ? message.getBasePath() : basePath, message.getLine() != 0 ? message.getLine() : line, message.getColumn() != 0 ? message.getColumn() : column, message.getThrowable() != null ? message.getThrowable() : t);
        this.validatorId = validatorId;
    }

    private ValidationViolation(String validatorId, ValidationMessage message) {
        this(validatorId, message, null, null, null, 0, 0, null);
    }

    public ValidationViolation(String validatorId, @NotNull ValidationMessageSeverity severity, @NotNull String message) {
        this(validatorId, new ValidationMessage(severity, message));
    }

    public ValidationViolation(@NotNull ValidationMessageSeverity severity, @NotNull String message) {
        this(null, new ValidationMessage(severity, message));
    }

    public ValidationViolation(@NotNull ValidationMessageSeverity severity, @NotNull String message, Path filePath, Path basePath, String nodePath, int line, int column, Throwable t) {
        this(null, new ValidationMessage(severity, message), filePath, basePath, nodePath, line, column, t);
    }

    public ValidationViolation(String validatorId, @NotNull ValidationMessageSeverity severity, @NotNull String message, Path filePath, Path basePath, String nodePath, int line, int column, Throwable t) {
        this(validatorId, new ValidationMessage(severity, message), filePath, basePath, nodePath, line, column, t);
    }

    @Nullable
    public Path getAbsoluteFilePath() {
        Path basePath = this.getBasePath();
        if (basePath != null && this.getFilePath() != null) {
            return basePath.resolve(this.getFilePath());
        }
        return this.getFilePath();
    }

    @Nullable
    public String getValidatorId() {
        return this.validatorId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.validatorId == null ? 0 : this.validatorId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationViolation other = (ValidationViolation)obj;
        return !(this.validatorId == null ? other.validatorId != null : !this.validatorId.equals(other.validatorId));
    }

    @Override
    public String toString() {
        return "ValidationViolation [" + (this.validatorId != null ? "validatorId=" + this.validatorId + ", " : "") + "super=" + super.toString() + "]";
    }
}

