/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.accesscontrol.Group;
import org.apache.sling.feature.cpconverter.handlers.AbstractUserEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.AbstractUserParser;
import org.apache.sling.feature.cpconverter.handlers.EntryHandler;
import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;

public final class GroupEntryHandler
extends AbstractUserEntryHandler {
    public GroupEntryHandler() {
        this("/jcr_root(/home/groups.*/)\\.content.xml");
    }

    public GroupEntryHandler(@NotNull String regex) {
        super(regex);
    }

    @Override
    public EntryHandler withConfig(@NotNull String config) {
        return new GroupEntryHandler(config);
    }

    @Override
    AbstractUserParser createParser(@NotNull ContentPackage2FeatureModelConverter converter, @NotNull RepoPath originalPath, @NotNull RepoPath intermediatePath) {
        return new GroupParser(converter, originalPath, intermediatePath);
    }

    private static final class GroupParser
    extends AbstractUserParser {
        private static final String REP_GROUP = "rep:Group";

        public GroupParser(@NotNull ContentPackage2FeatureModelConverter converter, @NotNull RepoPath path, @NotNull RepoPath intermediatePath) {
            super(converter, path, intermediatePath, REP_GROUP);
        }

        @Override
        void handleUser(@NotNull String id, @NotNull Attributes attributes) {
            this.converter.getAclManager().addGroup(new Group(id, this.path, this.intermediatePath));
        }
    }
}

