/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.accesscontrol.AclManager;
import org.apache.sling.feature.cpconverter.accesscontrol.DefaultAclManager;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactsDeployer;
import org.apache.sling.feature.cpconverter.artifacts.FileArtifactWriter;
import org.apache.sling.feature.cpconverter.features.FeaturesManager;
import org.apache.sling.feature.cpconverter.filtering.ResourceFilter;
import org.apache.sling.feature.cpconverter.handlers.DefaultHandler;
import org.apache.sling.feature.cpconverter.handlers.EntryHandler;
import org.apache.sling.feature.cpconverter.handlers.EntryHandlersManager;
import org.apache.sling.feature.cpconverter.handlers.NodeTypesEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.BundleSlingInitialContentExtractor;
import org.apache.sling.feature.cpconverter.index.DefaultIndexManager;
import org.apache.sling.feature.cpconverter.index.IndexManager;
import org.apache.sling.feature.cpconverter.vltpkg.BaseVaultPackageScanner;
import org.apache.sling.feature.cpconverter.vltpkg.PackagesEventsEmitter;
import org.apache.sling.feature.cpconverter.vltpkg.RecollectorVaultPackageScanner;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentPackage2FeatureModelConverter
extends BaseVaultPackageScanner
implements Closeable {
    public static final String ZIP_TYPE = "zip";
    public static final String PACKAGE_CLASSIFIER = "cp2fm-converted";
    private static final String DEFAULT_VERSION = "0.0.0";
    private final Map<PackageId, String> subContentPackages = new HashMap<PackageId, String>();
    private final List<VaultPackageAssembler> assemblers = new LinkedList<VaultPackageAssembler>();
    private final Map<PackageId, Set<Dependency>> mutableContentsIds = new LinkedHashMap<PackageId, Set<Dependency>>();
    private EntryHandlersManager handlersManager;
    private AclManager aclManager = new DefaultAclManager();
    private FeaturesManager featuresManager;
    private ResourceFilter resourceFilter;
    private ArtifactsDeployer artifactsDeployer;
    private ArtifactsDeployer unreferencedArtifactsDeployer;
    private VaultPackageAssembler mainPackageAssembler;
    private final RecollectorVaultPackageScanner recollectorVaultPackageScanner;
    private final List<PackagesEventsEmitter> emitters = new ArrayList<PackagesEventsEmitter>();
    private final List<Runnable> deployTasks = new ArrayList<Runnable>();
    private final File tmpDirectory;
    private boolean failOnMixedPackages = false;
    private PackagePolicy contentTypePackagePolicy = PackagePolicy.REFERENCE;
    private boolean removeInstallHooks = false;
    private boolean disablePackageTypeRecalculation = false;
    private BundleSlingInitialContentExtractor bundleSlingInitialContentExtractor = new BundleSlingInitialContentExtractor();
    private IndexManager indexManager = new DefaultIndexManager();
    private RunModePolicy runModePolicy = RunModePolicy.DIRECT_ONLY;

    public ContentPackage2FeatureModelConverter() throws IOException {
        this(false, SlingInitialContentPolicy.KEEP, false);
    }

    public ContentPackage2FeatureModelConverter(boolean strictValidation, @NotNull SlingInitialContentPolicy slingInitialContentPolicy) throws IOException {
        this(strictValidation, slingInitialContentPolicy, false);
    }

    public ContentPackage2FeatureModelConverter(boolean strictValidation, @NotNull SlingInitialContentPolicy slingInitialContentPolicy, boolean disablePackageTypeRecalculation) throws IOException {
        this(strictValidation, slingInitialContentPolicy, disablePackageTypeRecalculation, RunModePolicy.DIRECT_ONLY);
    }

    public ContentPackage2FeatureModelConverter(boolean strictValidation, @NotNull SlingInitialContentPolicy slingInitialContentPolicy, boolean disablePackageTypeRecalculation, @NotNull RunModePolicy runModePolicy) throws IOException {
        super(strictValidation);
        this.disablePackageTypeRecalculation = disablePackageTypeRecalculation;
        this.recollectorVaultPackageScanner = new RecollectorVaultPackageScanner(this, this.packageManager, strictValidation, this.subContentPackages, slingInitialContentPolicy);
        this.tmpDirectory = Files.createTempDirectory("cp2fm-converter", new FileAttribute[0]).toFile();
        this.runModePolicy = runModePolicy;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setEntryHandlersManager(@Nullable EntryHandlersManager handlersManager) {
        this.handlersManager = handlersManager;
        return this;
    }

    @Nullable
    public FeaturesManager getFeaturesManager() {
        return this.featuresManager;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setFeaturesManager(@NotNull FeaturesManager featuresManager) {
        this.featuresManager = featuresManager;
        if (featuresManager instanceof PackagesEventsEmitter) {
            this.emitters.add((PackagesEventsEmitter)((Object)featuresManager));
        }
        return this;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setResourceFilter(@Nullable ResourceFilter resourceFilter) {
        this.resourceFilter = resourceFilter;
        return this;
    }

    @Nullable
    public ArtifactsDeployer getArtifactsDeployer() {
        return this.artifactsDeployer;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setBundlesDeployer(@NotNull ArtifactsDeployer bundlesDeployer) {
        this.artifactsDeployer = bundlesDeployer;
        return this;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setUnreferencedArtifactsDeployer(@NotNull ArtifactsDeployer unreferencedArtifactsDeployer) {
        this.unreferencedArtifactsDeployer = unreferencedArtifactsDeployer;
        return this;
    }

    @NotNull
    public AclManager getAclManager() {
        return this.aclManager;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setAclManager(@NotNull AclManager aclManager) {
        this.aclManager = aclManager;
        return this;
    }

    public boolean hasMainPackageAssembler() {
        return this.mainPackageAssembler != null;
    }

    @NotNull
    public VaultPackageAssembler getMainPackageAssembler() {
        return Objects.requireNonNull(this.mainPackageAssembler);
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setMainPackageAssembler(@NotNull VaultPackageAssembler assembler) {
        this.mainPackageAssembler = assembler;
        return this;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setEmitter(@NotNull PackagesEventsEmitter emitter) {
        this.emitters.add(emitter);
        return this;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setContentTypePackagePolicy(@NotNull PackagePolicy contentTypePackagePolicy) {
        this.contentTypePackagePolicy = contentTypePackagePolicy;
        return this;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setFailOnMixedPackages(boolean failOnMixedPackages) {
        this.failOnMixedPackages = failOnMixedPackages;
        return this;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setRemoveInstallHooks(boolean removeInstallHook) {
        this.removeInstallHooks = removeInstallHook;
        return this;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setRunModePolicy(@NotNull RunModePolicy runModePolicy) {
        this.runModePolicy = runModePolicy;
        return this;
    }

    public RunModePolicy getRunModePolicy() {
        return this.runModePolicy;
    }

    @Nullable
    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
        return this;
    }

    @NotNull
    public File getTempDirectory() {
        return this.tmpDirectory;
    }

    public void cleanup() throws IOException {
        if (this.tmpDirectory.exists()) {
            this.logger.info("Cleaning up tmp directory {}", (Object)this.tmpDirectory);
            FileUtils.deleteDirectory((File)this.tmpDirectory);
        }
    }

    public void convert(File ... contentPackages) throws IOException, ConverterException {
        Objects.requireNonNull(contentPackages, "Null content-package(s) can not be converted.");
        this.secondPass(this.firstPass(contentPackages));
    }

    @NotNull
    protected Collection<VaultPackage> firstPass(File ... contentPackages) throws IOException, ConverterException {
        LinkedHashMap<PackageId, VaultPackage> idFileMap = new LinkedHashMap<PackageId, VaultPackage>();
        ConcurrentHashMap<PackageId, VaultPackage> idPackageMapping = new ConcurrentHashMap<PackageId, VaultPackage>();
        for (File contentPackage : contentPackages) {
            Objects.requireNonNull(contentPackage, "Null content-package can not be converted.");
            if (!contentPackage.exists() || !contentPackage.isFile()) {
                throw new IllegalArgumentException("File " + contentPackage + " does not exist or it is a directory");
            }
            this.logger.info("Reading content-package '{}'...", (Object)contentPackage);
            VaultPackage pack = this.open(contentPackage);
            idPackageMapping.put(pack.getId(), pack);
            this.recollectorVaultPackageScanner.traverse(pack, null);
            this.logger.info("content-package '{}' successfully read!", (Object)contentPackage);
            this.aclManager.reset();
            this.bundleSlingInitialContentExtractor.reset();
        }
        this.logger.info("Ordering input content-package(s) {}...", idPackageMapping.keySet());
        for (VaultPackage pack : idPackageMapping.values()) {
            ContentPackage2FeatureModelConverter.orderDependencies(idFileMap, idPackageMapping, pack, new HashSet<PackageId>());
        }
        this.logger.info("New content-package(s) order: {}", idFileMap.keySet());
        return idFileMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void secondPass(@NotNull Collection<VaultPackage> orderedContentPackages) throws IOException, ConverterException {
        this.emitters.stream().forEach(PackagesEventsEmitter::start);
        for (VaultPackage vaultPackage : orderedContentPackages) {
            try {
                this.emitters.stream().forEach(e -> e.startPackage(vaultPackage));
                this.setMainPackageAssembler(VaultPackageAssembler.create(this.getTempDirectory(), vaultPackage, this.removeInstallHooks, this.disablePackageTypeRecalculation));
                this.assemblers.add(this.getMainPackageAssembler());
                ArtifactId mvnPackageId = ContentPackage2FeatureModelConverter.toArtifactId(vaultPackage.getId(), vaultPackage.getFile());
                this.featuresManager.init(mvnPackageId);
                this.logger.info("Converting content-package '{}'...", (Object)vaultPackage.getId());
                this.traverse(vaultPackage, null);
                VaultPackage result = this.processContentPackageArchive(this.getMainPackageAssembler(), null);
                try {
                    this.aclManager.addRepoinitExtension(this.assemblers, this.featuresManager);
                    this.bundleSlingInitialContentExtractor.addRepoInitExtension(this.assemblers, this.featuresManager);
                    this.indexManager.addRepoinitExtension(this.featuresManager);
                    this.logger.info("Conversion complete!");
                    this.featuresManager.serialize();
                    this.emitters.stream().forEach(e -> e.endPackage(vaultPackage.getId(), result));
                }
                finally {
                    if (result == null) continue;
                    result.close();
                }
            }
            finally {
                this.aclManager.reset();
                this.bundleSlingInitialContentExtractor.reset();
                this.indexManager.reset();
                this.assemblers.clear();
                try {
                    vaultPackage.close();
                }
                catch (Exception exception) {}
            }
        }
        this.deployPackages();
        this.mutableContentsIds.clear();
        this.emitters.stream().forEach(PackagesEventsEmitter::end);
    }

    private static void orderDependencies(@NotNull Map<PackageId, VaultPackage> idFileMap, @NotNull Map<PackageId, VaultPackage> idPackageMapping, @NotNull VaultPackage pack, @NotNull Set<PackageId> visited) throws IOException, ConverterException {
        if (!visited.add(pack.getId())) {
            throw new ConverterException("Cyclic dependency detected, " + pack.getId() + " was previously visited already");
        }
        block0: for (Dependency dep : pack.getDependencies()) {
            for (Map.Entry<PackageId, VaultPackage> entry : idPackageMapping.entrySet()) {
                if (!dep.matches(entry.getKey())) continue;
                ContentPackage2FeatureModelConverter.orderDependencies(idFileMap, idPackageMapping, entry.getValue(), visited);
                continue block0;
            }
        }
        idFileMap.put(pack.getId(), pack);
        idPackageMapping.remove(pack.getId());
    }

    public void processSubPackage(@NotNull String path, @Nullable String runMode, @NotNull VaultPackage vaultPackage, boolean isEmbeddedPackage) throws IOException, ConverterException {
        Objects.requireNonNull(path, "Impossible to process a null vault package");
        Objects.requireNonNull(vaultPackage, "Impossible to process a null vault package");
        if (!this.isSubContentPackageIncluded(path)) {
            this.logger.info("Sub content-package {} is filtered out, so it won't be processed.", (Object)path);
            return;
        }
        this.emitters.stream().forEach(e -> e.startSubPackage(path, vaultPackage));
        VaultPackageAssembler clonedPackage = VaultPackageAssembler.create(this.getTempDirectory(), vaultPackage, this.removeInstallHooks, this.disablePackageTypeRecalculation);
        VaultPackageAssembler handler = this.getMainPackageAssembler();
        Properties parentProps = handler.getPackageProperties();
        String parentTypeStr = (String)parentProps.get("packageType");
        boolean isContainerPackage = StringUtils.isNotBlank((CharSequence)parentTypeStr) ? PackageType.CONTAINER.equals((Object)PackageType.valueOf((String)parentTypeStr.toUpperCase(Locale.ENGLISH))) : false;
        this.setMainPackageAssembler(clonedPackage);
        this.assemblers.add(clonedPackage);
        this.traverse(vaultPackage, runMode);
        if (isEmbeddedPackage && !isContainerPackage) {
            PackageId parentId = new PackageId((String)parentProps.get("group"), (String)parentProps.get("name"), (String)parentProps.get("version"));
            clonedPackage.addDependency(new Dependency(parentId));
        }
        try (VaultPackage result = this.processContentPackageArchive(clonedPackage, runMode);){
            this.emitters.stream().forEach(e -> e.endSubPackage(path, vaultPackage.getId(), result));
        }
        this.setMainPackageAssembler(handler);
    }

    @NotNull
    private VaultPackage processContentPackageArchive(@NotNull VaultPackageAssembler assembler, @Nullable String runMode) throws IOException, ConverterException {
        File contentPackageArchive = assembler.createPackage();
        VaultPackage vaultPackage = this.open(contentPackageArchive);
        PackageType packageType = VaultPackageUtils.detectPackageType(vaultPackage);
        if (PackageType.MIXED == packageType && this.failOnMixedPackages) {
            throw new ConverterException("Generated content-package '" + vaultPackage.getId() + "' located in file " + contentPackageArchive + " is of MIXED type");
        }
        ArtifactId mvnPackageId = ContentPackage2FeatureModelConverter.toArtifactId(vaultPackage.getId(), contentPackageArchive);
        if (PackageType.CONTENT == packageType) {
            switch (this.contentTypePackagePolicy.ordinal()) {
                case 1: {
                    this.mutableContentsIds.put(vaultPackage.getId(), VaultPackageUtils.getDependencies(vaultPackage));
                    this.logger.info("Dropping package of PackageType.CONTENT {} (content-package id: {})", (Object)mvnPackageId.getArtifactId(), (Object)vaultPackage.getId());
                    break;
                }
                case 2: {
                    this.mutableContentsIds.put(vaultPackage.getId(), VaultPackageUtils.getDependencies(vaultPackage));
                    if (this.unreferencedArtifactsDeployer == null) {
                        throw new IllegalStateException("ContentTypePackagePolicy PUT_IN_DEDICATED_FOLDER requires a valid deployer ");
                    }
                    String location = this.unreferencedArtifactsDeployer.deploy(new FileArtifactWriter(contentPackageArchive), runMode, mvnPackageId);
                    this.logger.info("Put converted package of PackageType.CONTENT {} (content-package id: {}) at {} (not referenced in feature model)", new Object[]{mvnPackageId.getArtifactId(), vaultPackage.getId(), location});
                    break;
                }
                case 0: {
                    this.deploy(assembler, mvnPackageId, runMode);
                }
            }
        } else {
            this.deploy(assembler, mvnPackageId, runMode);
        }
        return vaultPackage;
    }

    public void deployPackages() {
        try {
            this.mutableContentsIds.values().forEach(value -> value.removeIf(dep -> this.mutableContentsIds.keySet().stream().anyMatch(arg_0 -> ((Dependency)dep).matches(arg_0))));
            this.deployTasks.forEach(Runnable::run);
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof Exception) {
                throw ex;
            }
            throw ex;
        }
        this.deployTasks.clear();
    }

    private void deploy(@NotNull VaultPackageAssembler assembler, @NotNull ArtifactId mvnPackageId, @Nullable String runMode) {
        Objects.requireNonNull(this.getFeaturesManager()).addArtifact(runMode, mvnPackageId);
        ArtifactsDeployer deployer = Objects.requireNonNull(this.getArtifactsDeployer());
        this.deployTasks.add(() -> {
            assembler.updateDependencies(this.mutableContentsIds);
            try {
                File finalContentPackageArchive = assembler.createPackage();
                deployer.deploy(new FileArtifactWriter(finalContentPackageArchive), runMode, mvnPackageId);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public boolean isSubContentPackageIncluded(@NotNull String path) {
        return this.subContentPackages.containsValue(path);
    }

    private void process(@NotNull String entryPath, @NotNull Archive archive, @Nullable Archive.Entry entry, String runMode) throws IOException, ConverterException {
        if (this.resourceFilter != null && this.resourceFilter.isFilteredOut(entryPath)) {
            throw new ConverterException("Path '" + entryPath + "' in archive " + archive.getMetaInf().getPackageProperties().getId() + " not allowed by user configuration, please check configured filtering patterns");
        }
        EntryHandler entryHandler = this.handlersManager.getEntryHandlerByEntryPath(entryPath);
        if (entryHandler == null) {
            entryHandler = new DefaultHandler(this.getMainPackageAssembler(), this.removeInstallHooks);
        }
        if (entry == null && (entry = archive.getEntry(entryPath)) == null) {
            throw new IllegalArgumentException("Archive '" + archive.getMetaInf().getPackageProperties().getId() + "' does not contain entry with path '" + entryPath + "'");
        }
        entryHandler.handle(entryPath, archive, entry, this, runMode);
        if (!this.getMainPackageAssembler().recordEntryPath(entryPath)) {
            this.logger.warn("Duplicate entry path {}", (Object)entryPath);
        }
    }

    public ContentPackage2FeatureModelConverter setBundleSlingInitialContentExtractor(BundleSlingInitialContentExtractor bundleSlingInitialContentExtractor) {
        this.bundleSlingInitialContentExtractor = bundleSlingInitialContentExtractor;
        return this;
    }

    @Override
    protected void onFile(@NotNull String entryPath, @NotNull Archive archive, @NotNull Archive.Entry entry, String runMode) throws IOException, ConverterException {
        try {
            this.process(entryPath, archive, entry, runMode);
        }
        catch (ConverterException ex) {
            throw new ConverterException("ConverterException occured on path " + entryPath + " with message: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new IOException("IOException occured on path " + entryPath + " with message: " + ex.getMessage(), ex);
        }
    }

    @NotNull
    public static ArtifactId toArtifactId(@NotNull PackageId packageId, @NotNull File file) {
        String groupId = Objects.requireNonNull(packageId.getGroup(), "group property not found in content-package " + file + ", please check META-INF/vault/properties.xml").replace('/', '.');
        groupId = groupId.replace(" ", "_");
        String artifactId = Objects.requireNonNull(packageId.getName(), "name property not found in content-package " + file + ", please check META-INF/vault/properties.xml");
        artifactId = artifactId.replace(" ", "_");
        String version = packageId.getVersionString();
        if (version.endsWith("-cp2fm-converted")) {
            version = version.substring(0, version.length() - "-cp2fm-converted".length());
        }
        if (version.isEmpty()) {
            version = DEFAULT_VERSION;
        }
        return new ArtifactId(groupId, artifactId, version, PACKAGE_CLASSIFIER, ZIP_TYPE);
    }

    @Override
    protected void addCdnPattern(@NotNull Pattern cndPattern) {
        this.handlersManager.addEntryHandler(NodeTypesEntryHandler.forCndPattern(cndPattern));
    }

    @Override
    public void close() throws IOException {
        this.cleanup();
    }

    public List<VaultPackageAssembler> getAssemblers() {
        return new ArrayList<VaultPackageAssembler>(this.assemblers);
    }

    public static enum SlingInitialContentPolicy {
        KEEP,
        EXTRACT_AND_REMOVE,
        EXTRACT_AND_KEEP;

    }

    public static enum RunModePolicy {
        DIRECT_ONLY,
        PREPEND_INHERITED;

    }

    public static enum PackagePolicy {
        REFERENCE,
        DROP,
        PUT_IN_DEDICATED_FOLDER;

    }
}

