/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.json.io;

import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import org.apache.felix.cm.json.io.ConfigurationReader;
import org.apache.felix.cm.json.io.ConfigurationWriter;
import org.apache.felix.cm.json.io.impl.ConfigurationReaderImpl;
import org.apache.felix.cm.json.io.impl.ConfigurationWriterImpl;
import org.apache.felix.cm.json.io.impl.JsonSupport;
import org.apache.felix.cm.json.io.impl.OrderedDictionary;

public class Configurations {
    private Configurations() {
    }

    public static ConfigurationReader.Builder buildReader() {
        return new ConfigurationReaderImpl();
    }

    public static ConfigurationWriter.Builder buildWriter() {
        return new ConfigurationWriterImpl();
    }

    public static Reader jsonCommentAwareReader(Reader reader) throws IOException {
        return JsonSupport.createCommentRemovingReader(reader);
    }

    public static Hashtable<String, Object> newConfiguration() {
        return new OrderedDictionary();
    }

    public static Object convertToObject(JsonValue value) {
        return JsonSupport.convertToObject(value);
    }

    public static JsonValue convertToJsonValue(Object value) {
        return JsonSupport.convertToJson(value);
    }
}

