/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentparser.impl;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.PropertyType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.jcr.contentparser.ContentHandler;
import org.apache.sling.jcr.contentparser.ContentParser;
import org.apache.sling.jcr.contentparser.ParseException;
import org.apache.sling.jcr.contentparser.ParserOptions;
import org.apache.sling.jcr.contentparser.impl.ParserHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XmlContentParser
implements ContentParser {
    private final ParserHelper helper;
    private final DocumentBuilderFactory documentBuilderFactory;

    public XmlContentParser(ParserOptions options) {
        this.helper = new ParserHelper(options);
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
    }

    @Override
    public void parse(ContentHandler handler, InputStream is) throws IOException, ParseException {
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            Document doc = documentBuilder.parse(is);
            this.parse(handler, doc.getDocumentElement(), null);
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new ParseException("Error parsing JCR XML content.", ex);
        }
    }

    private void parse(ContentHandler handler, Element element, String parentPath) {
        String[] mixins;
        String path;
        if (parentPath == null) {
            path = "/";
        } else {
            String name = this.getChildText(element, "name");
            if (StringUtils.isEmpty((CharSequence)name)) {
                throw new ParseException("Child node without name detected below path " + parentPath);
            }
            path = this.helper.concatenatePath(parentPath, name);
            if (this.helper.ignoreResource(name)) {
                return;
            }
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String primaryType = this.getChildText(element, "primaryNodeType");
        if (StringUtils.isNotBlank((CharSequence)primaryType) && !this.helper.ignoreProperty("jcr:primaryType")) {
            properties.put("jcr:primaryType", primaryType);
        }
        if ((mixins = this.getChildTextArray(element, "mixinNodeType")).length > 0 && !this.helper.ignoreProperty("jcr:mixinTypes")) {
            properties.put("jcr:mixinTypes", mixins);
        }
        List<Element> propertyElements = this.getChildren(element, "property");
        for (Element propertyElement : propertyElements) {
            Object value;
            int type;
            String name = this.getChildText(propertyElement, "name");
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new ParseException("Property without name detected at path " + path);
            }
            if (this.helper.ignoreProperty(name)) continue;
            String typeString = this.getChildText(propertyElement, "type");
            if (StringUtils.isBlank((CharSequence)typeString)) {
                throw new ParseException("Property '" + name + "' has no type at path " + path);
            }
            try {
                type = PropertyType.valueFromName((String)typeString);
            }
            catch (IllegalArgumentException ex) {
                throw new ParseException("Property '" + name + "' has illegal type '" + typeString + "' at path " + path);
            }
            List<Element> valuesElements = this.getChildren(propertyElement, "values");
            if (!valuesElements.isEmpty()) {
                Element valuesElement = valuesElements.get(0);
                List<Element> valueElements = this.getChildren(valuesElement, "value");
                String[] stringValues = new String[valueElements.size()];
                for (int i = 0; i < valueElements.size(); ++i) {
                    stringValues[i] = valueElements.get(i).getTextContent();
                }
                value = this.convertMultiValue(stringValues, type);
            } else {
                String stringValue = this.getChildText(propertyElement, "value");
                value = this.convertValue(stringValue, type);
            }
            properties.put(name, value);
        }
        this.helper.ensureDefaultPrimaryType(properties);
        handler.resource(path, properties);
        List<Element> nodeElements = this.getChildren(element, "node");
        for (Element node : nodeElements) {
            this.parse(handler, node, path);
        }
    }

    private List<Element> getChildren(Element element, String childName) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Element childElement;
            Node child = children.item(i);
            if (!(child instanceof Element) || !StringUtils.equals((CharSequence)(childElement = (Element)child).getNodeName(), (CharSequence)childName)) continue;
            result.add(childElement);
        }
        return result;
    }

    private String getChildText(Element element, String childName) {
        List<Element> children = this.getChildren(element, childName);
        if (children.isEmpty()) {
            return null;
        }
        if (children.size() == 1) {
            return children.get(0).getTextContent();
        }
        throw new ParseException("Found multiple elements with name '" + childName + "': " + children.size());
    }

    private String[] getChildTextArray(Element element, String childName) {
        List<Element> children = this.getChildren(element, childName);
        String[] result = new String[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            result[i] = children.get(i).getTextContent();
        }
        return result;
    }

    private Object convertValue(String value, int type) {
        switch (type) {
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return value;
            }
            case 3: {
                return Long.valueOf(value);
            }
            case 4: {
                return Double.valueOf(value);
            }
            case 5: {
                return this.helper.tryParseCalendar(value);
            }
            case 6: {
                return Boolean.valueOf(value);
            }
            case 12: {
                return new BigDecimal(value);
            }
        }
        throw new ParseException("Unsupported property type: " + PropertyType.nameFromValue((int)type));
    }

    private Object convertMultiValue(String[] values, int type) {
        Object[] result = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = this.convertValue(values[i], type);
        }
        return this.helper.convertSingleTypeArray(result);
    }
}

