/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.cache;

import java.util.Arrays;
import java.util.Iterator;
import javax.inject.Inject;
import org.ops4j.peaberry.AttributeFilter;
import org.ops4j.peaberry.Export;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.ServiceRegistry;
import org.ops4j.peaberry.ServiceWatcher;
import org.ops4j.peaberry.cache.Chain;
import org.ops4j.peaberry.cache.IteratorChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryChain
implements ServiceRegistry {
    private final ServiceRegistry[] registries;

    @Inject
    public RegistryChain(@Chain ServiceRegistry mainRegistry, @Chain ServiceRegistry[] extraRegistries) {
        this.registries = new ServiceRegistry[1 + extraRegistries.length];
        System.arraycopy(extraRegistries, 0, this.registries, 1, extraRegistries.length);
        this.registries[0] = mainRegistry;
    }

    @Override
    public final <T> Iterable<Import<T>> lookup(final Class<T> clazz, final AttributeFilter filter) {
        final Iterable[] lazyIterables = new Iterable[this.registries.length];
        for (int i = 0; i < this.registries.length; ++i) {
            final ServiceRegistry reg = this.registries[i];
            lazyIterables[i] = new Iterable<Import<T>>(){
                private volatile Iterable<Import<T>> iterable;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Iterator<Import<T>> iterator() {
                    if (null == this.iterable) {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (null == this.iterable) {
                                this.iterable = reg.lookup(clazz, filter);
                            }
                        }
                    }
                    return this.iterable.iterator();
                }
            };
        }
        return new Iterable<Import<T>>(){

            @Override
            public Iterator<Import<T>> iterator() {
                return new IteratorChain(lazyIterables);
            }
        };
    }

    @Override
    public final <T> void watch(Class<T> clazz, AttributeFilter filter, ServiceWatcher<? super T> watcher) {
        for (ServiceRegistry r : this.registries) {
            try {
                r.watch(clazz, filter, watcher);
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
    }

    @Override
    public final <T> Export<T> add(Import<T> service) {
        return this.registries[0].add(service);
    }

    public final String toString() {
        return String.format("RegistryChain%s", Arrays.toString(this.registries));
    }

    public final int hashCode() {
        return Arrays.hashCode(this.registries);
    }

    public final boolean equals(Object rhs) {
        if (rhs instanceof RegistryChain) {
            return Arrays.equals(this.registries, ((RegistryChain)rhs).registries);
        }
        return false;
    }
}

