/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl.nodetype;

import java.util.LinkedList;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.apache.jackrabbit.vault.util.DocViewProperty2;

public class DocViewPropertyValueFactory {
    private final ValueFactory valueFactory = ValueFactoryImpl.getInstance();

    private Value getValue(String value, int type) throws ValueFormatException {
        if (type == 0) {
            type = 1;
        }
        return this.valueFactory.createValue(value, type);
    }

    public Value getValue(DocViewProperty2 property) throws ValueFormatException {
        return this.getValue((String)property.getStringValue().orElseThrow(() -> new IllegalStateException("Property does not have a value")), property.getType());
    }

    public Value[] getValues(DocViewProperty2 property) throws ValueFormatException {
        LinkedList<Value> values = new LinkedList<Value>();
        for (String value : property.getStringValues()) {
            values.add(this.getValue(value, property.getType()));
        }
        return values.toArray(new Value[values.size()]);
    }
}

