/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.vltpkg;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.PackageManager;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.impl.PackageManagerImpl;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseVaultPackageScanner {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final PackageManager packageManager;
    protected final boolean strictValidation;

    public BaseVaultPackageScanner(boolean strictValidation) {
        this((PackageManager)new PackageManagerImpl(), strictValidation);
    }

    public BaseVaultPackageScanner(@NotNull PackageManager packageManager, boolean strictValidation) {
        this.packageManager = packageManager;
        this.strictValidation = strictValidation;
    }

    @NotNull
    public VaultPackage open(@NotNull File vaultPackage) throws IOException, ConverterException {
        Objects.requireNonNull(vaultPackage, "Impossible to process a null vault package");
        return this.packageManager.open(vaultPackage, this.strictValidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void traverse(@NotNull File vaultPackageFile, boolean closeOnTraversed, String runMode) throws IOException, ConverterException {
        VaultPackage vaultPackage = null;
        try {
            vaultPackage = this.open(vaultPackageFile);
            this.traverse(vaultPackage, runMode);
        }
        finally {
            if (closeOnTraversed && vaultPackage != null) {
                vaultPackage.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void traverse(@NotNull VaultPackage vaultPackage, String runMode) throws IOException, ConverterException {
        Objects.requireNonNull(vaultPackage, "Impossible to process a null vault package");
        PackageProperties properties = vaultPackage.getProperties();
        ImportOptions importOptions = new ImportOptions();
        String cndPattern = properties.getProperty("cndPattern");
        if (cndPattern != null && !cndPattern.isEmpty()) {
            importOptions.setCndPattern(cndPattern);
        }
        this.addCdnPattern(importOptions.getCndPattern());
        try (Archive archive = vaultPackage.getArchive();){
            archive.open(this.strictValidation);
            Archive.Entry root = archive.getRoot();
            this.traverse(null, archive, root, runMode);
        }
    }

    private void traverse(@Nullable String path, @NotNull Archive archive, @NotNull Archive.Entry entry, String runMode) throws IOException, ConverterException {
        String entryPath = BaseVaultPackageScanner.newPath(path, entry.getName());
        if (entry.isDirectory()) {
            this.onDirectory(entryPath, archive, entry);
            for (Archive.Entry child : entry.getChildren()) {
                this.traverse(entryPath, archive, child, runMode);
            }
            return;
        }
        this.logger.debug("Processing entry {}...", (Object)entryPath);
        this.onFile(entryPath, archive, entry, runMode);
        this.logger.debug("Entry {} successfully processed.", (Object)entryPath);
    }

    @NotNull
    private static String newPath(@Nullable String path, @NotNull String entryName) {
        if (path == null) {
            return entryName;
        }
        return path + '/' + entryName;
    }

    protected void onDirectory(@NotNull String path, @NotNull Archive archive, @NotNull Archive.Entry entry) throws IOException, ConverterException {
    }

    protected void onFile(@NotNull String path, @NotNull Archive archive, @NotNull Archive.Entry entry, String runMode) throws IOException, ConverterException {
    }

    protected void addCdnPattern(@NotNull Pattern cndPattern) {
    }
}

