/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.index;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.jetbrains.annotations.NotNull;

public class IndexDefinitions {
    public static final String OAK_INDEX_NAME = "oak:index";
    public static final String OAK_INDEX_PATH = "/oak:index";
    private final Map<String, List<DocViewNode2>> children = new HashMap<String, List<DocViewNode2>>();
    private final Map<String, byte[]> binaries = new HashMap<String, byte[]>();
    private Map<String, String> prefixesToUris = new HashMap<String, String>();
    private Map<String, String> urisToPrefixes = new HashMap<String, String>();

    public void addNode(@NotNull String parentPath, @NotNull DocViewNode2 node) {
        List currentChildren = this.children.computeIfAbsent(parentPath, k -> new ArrayList());
        DocViewNode2 existing = null;
        if (CollectionUtils.isEmpty((Collection)node.getProperties()) && (this.binaries.get(parentPath + "/" + node.getName().getLocalName()) == null || node.getName().getLocalName().contains(".xml"))) {
            return;
        }
        for (DocViewNode2 currentChild : currentChildren) {
            if (!currentChild.getName().equals(node.getName())) continue;
            if (node.getProperties().size() <= currentChild.getProperties().size()) {
                return;
            }
            existing = currentChild;
        }
        if (existing != null) {
            currentChildren.remove(existing);
        }
        currentChildren.add(node);
    }

    @NotNull
    public Map<String, List<DocViewNode2>> getIndexes() {
        return this.children.entrySet().stream().filter(e -> ((String)e.getKey()).endsWith(OAK_INDEX_PATH)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @NotNull
    public List<DocViewNode2> getChildren(@NotNull String parentPath) {
        return this.children.getOrDefault(parentPath, Collections.emptyList());
    }

    @NotNull
    public String toShortName(@NotNull Name name) {
        if (name.getNamespaceURI().length() == 0) {
            return name.getLocalName();
        }
        return this.urisToPrefixes.get(name.getNamespaceURI()) + ":" + name.getLocalName();
    }

    public void registerBinary(@NotNull String repositoryPath, @NotNull InputStream is) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)out);
        this.binaries.put(repositoryPath, out.toByteArray());
    }

    @NotNull
    public Optional<byte[]> getBinary(@NotNull String repositoryPath) {
        return Optional.ofNullable(this.binaries.get(repositoryPath));
    }

    public void registerPrefixMapping(@NotNull String prefix, @NotNull String uri) {
        this.prefixesToUris.put(prefix, uri);
        this.urisToPrefixes.put(uri, prefix);
    }

    public void dump(@NotNull PrintStream out) {
        out.println("---------");
        out.println(OAK_INDEX_NAME);
        this.dumpChildren(out, OAK_INDEX_PATH);
        out.println("---------");
    }

    private void dumpChildren(PrintStream out, String parentPath) {
        StringBuilder padding = new StringBuilder();
        int depth = parentPath.split("/").length - 1;
        for (int i = 0; i < 2 * depth; ++i) {
            padding.append(' ');
        }
        for (DocViewNode2 node : this.children.getOrDefault(parentPath, Collections.emptyList())) {
            out.println(padding.toString() + this.toShortName(node.getName()));
            this.dumpChildren(out, parentPath + '/' + node.getName().getLocalName());
        }
    }
}

