/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.query;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.QueryResultRow;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;

class RowIteratorImpl
implements RowIterator {
    private final RangeIterator rows;
    private final String[] columnNames;
    private final NamePathResolver resolver;
    private final ValueFactory vFactory;
    private final ItemManager itemMgr;
    private final HierarchyManager hmgr;

    RowIteratorImpl(QueryInfo queryInfo, NamePathResolver resolver, ValueFactory vFactory, ItemManager itemMgr, HierarchyManager hmgr) {
        this.rows = queryInfo.getRows();
        this.columnNames = queryInfo.getColumnNames();
        this.resolver = resolver;
        this.vFactory = vFactory;
        this.itemMgr = itemMgr;
        this.hmgr = hmgr;
    }

    public Row nextRow() throws NoSuchElementException {
        return new RowImpl((QueryResultRow)this.rows.next());
    }

    public void skip(long skipNum) throws NoSuchElementException {
        this.rows.skip(skipNum);
    }

    public long getSize() {
        return this.rows.getSize();
    }

    public long getPosition() {
        return this.rows.getPosition();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public boolean hasNext() {
        return this.rows.hasNext();
    }

    public Object next() throws NoSuchElementException {
        return this.nextRow();
    }

    class RowImpl
    implements Row {
        private final QueryResultRow row;
        private Value[] values;
        private Map<String, Integer> propertyMap;

        private RowImpl(QueryResultRow row) {
            this.row = row;
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                QValue[] qVals = this.row.getValues();
                Value[] tmp = new Value[qVals.length];
                for (int i = 0; i < qVals.length; ++i) {
                    tmp[i] = qVals[i] == null ? null : ValueFormat.getJCRValue((QValue)qVals[i], (NamePathResolver)RowIteratorImpl.this.resolver, (ValueFactory)RowIteratorImpl.this.vFactory);
                }
                this.values = tmp;
            }
            Value[] ret = new Value[this.values.length];
            System.arraycopy(this.values, 0, ret, 0, this.values.length);
            return ret;
        }

        public Value getValue(String propertyName) throws ItemNotFoundException, RepositoryException {
            if (this.propertyMap == null) {
                HashMap<String, Integer> tmp = new HashMap<String, Integer>();
                for (int i = 0; i < RowIteratorImpl.this.columnNames.length; ++i) {
                    tmp.put(RowIteratorImpl.this.columnNames[i], i);
                }
                this.propertyMap = tmp;
            }
            try {
                Integer idx = this.propertyMap.get(propertyName);
                if (idx == null) {
                    throw new ItemNotFoundException(propertyName);
                }
                if (this.values == null) {
                    this.getValues();
                }
                return this.values[idx];
            }
            catch (NameException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
        }

        public Node getNode() throws RepositoryException {
            return this.getNode(this.row.getNodeId(null));
        }

        public Node getNode(String selectorName) throws RepositoryException {
            return this.getNode(this.row.getNodeId(selectorName));
        }

        public String getPath() throws RepositoryException {
            String path = null;
            Node n = this.getNode();
            if (n != null) {
                path = n.getPath();
            }
            return path;
        }

        public String getPath(String selectorName) throws RepositoryException {
            String path = null;
            Node n = this.getNode(selectorName);
            if (n != null) {
                path = n.getPath();
            }
            return path;
        }

        public double getScore() throws RepositoryException {
            return this.row.getScore(null);
        }

        public double getScore(String selectorName) throws RepositoryException {
            return this.row.getScore(selectorName);
        }

        private Node getNode(NodeId id) throws RepositoryException {
            Node node = null;
            if (id != null) {
                node = (Node)RowIteratorImpl.this.itemMgr.getItem(RowIteratorImpl.this.hmgr.getNodeEntry(id));
            }
            return node;
        }
    }
}

