/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.security.authorization.jackrabbit.acl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.config.RepositoryConfig;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.jcr2spi.security.authorization.PrivilegeImpl;
import org.apache.jackrabbit.jcr2spi.security.authorization.jackrabbit.acl.AccessControlManagerImpl;
import org.apache.jackrabbit.jcr2spi.state.UpdatableItemStateManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.PrivilegeDefinition;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

public class AccessControlProviderImpl
implements AccessControlProvider {
    private RepositoryService service;
    private Map<Name, Privilege> privileges = new HashMap<Name, Privilege>();

    @Override
    public void init(RepositoryConfig config) throws RepositoryException {
        this.service = config.getRepositoryService();
    }

    @Override
    public Privilege privilegeFromName(SessionInfo sessionInfo, NamePathResolver resolver, String privilegeName) throws RepositoryException {
        Name name = resolver.getQName(privilegeName);
        Privilege priv = this.getPrivilegeFromName(sessionInfo, resolver, name);
        if (priv == null) {
            throw new AccessControlException("Unknown privilege " + privilegeName);
        }
        return priv;
    }

    @Override
    public Map<String, Privilege> getSupportedPrivileges(SessionInfo sessionInfo, NodeId nodeId, NamePathResolver npResolver) throws RepositoryException {
        PrivilegeDefinition[] pDefs = this.service.getSupportedPrivileges(sessionInfo, nodeId);
        HashMap<String, Privilege> privilegeMap = new HashMap<String, Privilege>(pDefs.length);
        for (PrivilegeDefinition def : pDefs) {
            PrivilegeImpl p = new PrivilegeImpl(def, pDefs, npResolver);
            privilegeMap.put(p.getName(), p);
        }
        return privilegeMap;
    }

    @Override
    public Set<Privilege> getPrivileges(SessionInfo sessionInfo, NodeId id, NamePathResolver npResolver) throws RepositoryException {
        Name[] privNames = this.service.getPrivilegeNames(sessionInfo, id);
        HashSet<Privilege> pvs = new HashSet<Privilege>(privNames.length);
        for (Name name : privNames) {
            Privilege priv = this.getPrivilegeFromName(sessionInfo, npResolver, name);
            if (priv == null) continue;
            pvs.add(priv);
        }
        return pvs;
    }

    @Override
    public AccessControlManager createAccessControlManager(SessionInfo sessionInfo, UpdatableItemStateManager itemStateManager, ItemManager itemManager, ItemDefinitionProvider definitionProvider, HierarchyManager hierarchyManager, NamePathResolver npResolver) throws RepositoryException {
        return new AccessControlManagerImpl(sessionInfo, itemStateManager, definitionProvider, hierarchyManager, npResolver, this.service.getQValueFactory(), this);
    }

    private void readPrivilegesFromService(SessionInfo sessionInfo, NamePathResolver resolver) throws RepositoryException {
        PrivilegeDefinition[] defs;
        for (PrivilegeDefinition d : defs = this.service.getPrivilegeDefinitions(sessionInfo)) {
            this.privileges.put(d.getName(), new PrivilegeImpl(d, defs, resolver));
        }
    }

    private Privilege getPrivilegeFromName(SessionInfo sessionInfo, NamePathResolver resolver, Name privilegeName) throws RepositoryException {
        Privilege priv = this.privileges.get(privilegeName);
        if (priv == null) {
            this.readPrivilegesFromService(sessionInfo, resolver);
            if (this.privileges.containsKey(privilegeName)) {
                priv = this.privileges.get(privilegeName);
            }
        }
        return priv;
    }
}

