/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader.internal.readers;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.CompositeRestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.sling.jcr.contentloader.ContentCreator;
import org.apache.sling.jcr.contentloader.ContentReader;
import org.apache.sling.jcr.contentloader.LocalPrivilege;
import org.apache.sling.jcr.contentloader.LocalRestriction;
import org.apache.sling.jcr.contentparser.impl.JsonTicksConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;

@Component(service={ContentReader.class}, property={"service.vendor=The Apache Software Foundation", "extensions=json", "contentTypes=application/json"})
public class JsonReader
implements ContentReader {
    private static final Pattern jsonDate = Pattern.compile("^[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}\\.[0-9]{3}[-+]{1}[0-9]{2}[:]{0,1}[0-9]{2}$");
    private static final String REFERENCE = "jcr:reference:";
    private static final String PATH = "jcr:path:";
    private static final String NAME = "jcr:name:";
    private static final String URI = "jcr:uri:";
    protected static final Set<String> ignoredNames = new HashSet<String>();
    private static final Set<String> ignoredPrincipalPropertyNames;
    private static final String SECURITY_PRINCIPLES = "security:principals";
    private static final String SECURITY_ACL = "security:acl";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(URL url, ContentCreator contentCreator) throws IOException, RepositoryException {
        InputStream ins = null;
        try {
            ins = url.openStream();
            this.parse(ins, contentCreator);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void parse(InputStream ins, ContentCreator contentCreator) throws IOException, RepositoryException {
        String jsonString = this.toString(ins).trim();
        if (!jsonString.startsWith("{")) {
            jsonString = "{" + jsonString + "}";
        }
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("org.apache.johnzon.supports-comments", true);
        try (jakarta.json.JsonReader reader = Json.createReaderFactory(config).createReader((Reader)new StringReader(JsonTicksConverter.tickToDoubleQuote(jsonString)));){
            JsonObject json = reader.readObject();
            this.createNode(null, json, contentCreator);
            contentCreator.finish();
        }
        catch (JsonException je) {
            throw (IOException)new IOException(je.getMessage()).initCause(je);
        }
    }

    protected boolean handleSecurity(String n, Object o, ContentCreator contentCreator) throws RepositoryException {
        if (SECURITY_PRINCIPLES.equals(n)) {
            this.createPrincipals(o, contentCreator);
        } else if (SECURITY_ACL.equals(n)) {
            this.createAcl(o, contentCreator);
        } else {
            return false;
        }
        return true;
    }

    protected void writeChildren(JsonObject obj, ContentCreator contentCreator) throws RepositoryException {
        for (Map.Entry entry : obj.entrySet()) {
            Object o;
            String n = (String)entry.getKey();
            if (ignoredNames.contains(n) || this.handleSecurity(n, o = entry.getValue(), contentCreator)) continue;
            if (o instanceof JsonObject) {
                this.createNode(n, (JsonObject)o, contentCreator);
                continue;
            }
            this.createProperty(n, o, contentCreator);
        }
    }

    protected void createNode(String name, JsonObject obj, ContentCreator contentCreator) throws RepositoryException {
        String primaryType = obj.getString("jcr:primaryType", null);
        String[] mixinTypes = null;
        Object mixinsObject = obj.get((Object)"jcr:mixinTypes");
        if (mixinsObject instanceof JsonArray) {
            JsonArray mixins = (JsonArray)mixinsObject;
            mixinTypes = new String[mixins.size()];
            for (int i = 0; i < mixinTypes.length; ++i) {
                mixinTypes[i] = mixins.getString(i);
            }
        }
        contentCreator.createNode(name, primaryType, mixinTypes);
        this.writeChildren(obj, contentCreator);
        contentCreator.finishNode();
    }

    protected void createProperty(String name, Object value, ContentCreator contentCreator) throws RepositoryException {
        if (value instanceof JsonArray) {
            JsonArray array = (JsonArray)value;
            if (!array.isEmpty()) {
                String[] values = new String[array.size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.unbox(array.get(i)).toString();
                }
                int propertyType = this.getType(name, this.unbox(array.get(0)));
                contentCreator.createProperty(this.getName(name), propertyType, values);
            } else {
                contentCreator.createProperty(this.getName(name), 1, new String[0]);
            }
        } else if (value instanceof JsonValue && (value = this.unbox(value)) != null) {
            contentCreator.createProperty(this.getName(name), this.getType(name, value), value.toString());
        }
    }

    private Object unbox(Object o) {
        if (o instanceof JsonValue) {
            switch (((JsonValue)o).getValueType()) {
                case FALSE: {
                    return false;
                }
                case TRUE: {
                    return true;
                }
                case NULL: {
                    return null;
                }
                case NUMBER: {
                    if (((JsonNumber)o).isIntegral()) {
                        return ((JsonNumber)o).longValue();
                    }
                    return ((JsonNumber)o).doubleValue();
                }
                case STRING: {
                    return ((JsonString)o).getString();
                }
            }
            return o;
        }
        return o;
    }

    private int getType(String name, Object object) {
        if (object == null) {
            return 1;
        }
        if (object instanceof Double || object instanceof Float) {
            return 4;
        }
        if (object instanceof Number) {
            return 3;
        }
        if (object instanceof Boolean) {
            return 6;
        }
        if (object instanceof String) {
            if (name.startsWith(REFERENCE)) {
                return 9;
            }
            if (name.startsWith(PATH)) {
                return 8;
            }
            if (name.startsWith(NAME)) {
                return 7;
            }
            if (name.startsWith(URI)) {
                return 11;
            }
            if (jsonDate.matcher((String)object).matches()) {
                return 5;
            }
        }
        return 0;
    }

    private String getName(String name) {
        if (name.startsWith(REFERENCE)) {
            return name.substring(REFERENCE.length());
        }
        if (name.startsWith(PATH)) {
            return name.substring(PATH.length());
        }
        if (name.startsWith(NAME)) {
            return name.substring(NAME.length());
        }
        if (name.startsWith(URI)) {
            return name.substring(URI.length());
        }
        return name;
    }

    private String toString(InputStream ins) throws IOException {
        int rd;
        String encoding;
        if (!ins.markSupported()) {
            ins = new BufferedInputStream(ins);
        }
        ins.mark(5);
        int c = ins.read();
        if (c == 35) {
            StringBuffer buf = new StringBuffer();
            c = ins.read();
            while (!Character.isWhitespace((char)c)) {
                buf.append((char)c);
                c = ins.read();
            }
            encoding = buf.toString();
        } else {
            ins.reset();
            encoding = "UTF-8";
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((rd = ins.read(buf)) >= 0) {
            bos.write(buf, 0, rd);
        }
        bos.close();
        return new String(bos.toByteArray(), encoding);
    }

    protected void createPrincipals(Object obj, ContentCreator contentCreator) throws RepositoryException {
        if (obj instanceof JsonObject) {
            this.createPrincipal((JsonObject)obj, contentCreator);
        } else if (obj instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)obj;
            for (int i = 0; i < jsonArray.size(); ++i) {
                Object object = jsonArray.get(i);
                if (!(object instanceof JsonObject)) {
                    throw new JsonException("Unexpected data type in principals array: " + object.getClass().getName());
                }
                this.createPrincipal((JsonObject)object, contentCreator);
            }
        }
    }

    private void createPrincipal(JsonObject json, ContentCreator contentCreator) throws RepositoryException {
        String name = json.getString("name");
        boolean isGroup = json.getBoolean("isgroup", false);
        LinkedHashMap<String, Object> extraProps = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : json.entrySet()) {
            String propName = (String)entry.getKey();
            if (ignoredPrincipalPropertyNames.contains(propName)) continue;
            Object value = this.unbox(entry.getValue());
            extraProps.put(propName, value);
        }
        if (isGroup) {
            String[] members = null;
            JsonArray membersJSONArray = (JsonArray)json.get((Object)"members");
            if (membersJSONArray != null) {
                members = new String[membersJSONArray.size()];
                for (int i = 0; i < members.length; ++i) {
                    members[i] = membersJSONArray.getString(i);
                }
            }
            contentCreator.createGroup(name, members, extraProps);
        } else {
            String password = json.getString("password");
            contentCreator.createUser(name, password, extraProps);
        }
    }

    private void createAcl(Object obj, ContentCreator contentCreator) throws RepositoryException {
        if (obj instanceof JsonObject) {
            this.createAce((JsonObject)obj, contentCreator);
        } else if (obj instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)obj;
            for (int i = 0; i < jsonArray.size(); ++i) {
                Object object = jsonArray.get(i);
                if (!(object instanceof JsonObject)) {
                    throw new JsonException("Unexpected data type in acl array: " + object.getClass().getName());
                }
                this.createAce((JsonObject)object, contentCreator);
            }
        }
    }

    private void createAce(JsonObject ace, ContentCreator contentCreator) throws RepositoryException {
        JsonValue privileges;
        String principalID = ace.getString("principal");
        String order = ace.getString("order", null);
        LinkedHashMap<String, LocalPrivilege> privilegeToLocalPrivilegesMap = new LinkedHashMap<String, LocalPrivilege>();
        Node parentNode = contentCreator.getParent();
        ValueFactory vf = parentNode.getSession().getValueFactory();
        Map<String, RestrictionDefinition> srMap = this.toSrMap(parentNode);
        JsonArray granted = (JsonArray)ace.get((Object)"granted");
        JsonArray denied = (JsonArray)ace.get((Object)"denied");
        if (granted != null || denied != null) {
            LocalPrivilege lp;
            String privilegeName;
            int a;
            JsonValue restrictions = (JsonValue)ace.get((Object)"restrictions");
            Set<LocalRestriction> restrictionsSet = Collections.emptySet();
            if (restrictions instanceof JsonObject) {
                restrictionsSet = this.toLocalRestrictions((JsonObject)restrictions, srMap, vf);
            }
            if (granted != null) {
                for (a = 0; a < granted.size(); ++a) {
                    privilegeName = granted.getString(a);
                    lp = privilegeToLocalPrivilegesMap.computeIfAbsent(privilegeName, LocalPrivilege::new);
                    lp.setAllow(true);
                    lp.setAllowRestrictions(restrictionsSet);
                }
            }
            if (denied != null) {
                for (a = 0; a < denied.size(); ++a) {
                    privilegeName = denied.getString(a);
                    lp = privilegeToLocalPrivilegesMap.computeIfAbsent(privilegeName, LocalPrivilege::new);
                    lp.setDeny(true);
                    lp.setDenyRestrictions(restrictionsSet);
                }
            }
        }
        if ((privileges = (JsonValue)ace.get((Object)"privileges")) instanceof JsonObject) {
            JsonObject privilegesObj = (JsonObject)privileges;
            for (Map.Entry entry : privilegesObj.entrySet()) {
                String privilegeName = (String)entry.getKey();
                JsonValue privilegeValue = (JsonValue)entry.getValue();
                if (!(privilegeValue instanceof JsonObject)) continue;
                JsonObject privilegeValueObj = (JsonObject)privilegeValue;
                JsonValue allow = (JsonValue)privilegeValueObj.get((Object)"allow");
                boolean isAllow = false;
                Set<LocalRestriction> allowRestrictions = Collections.emptySet();
                if (allow instanceof JsonObject) {
                    isAllow = true;
                    allowRestrictions = this.toLocalRestrictions((JsonObject)allow, srMap, vf);
                } else if (JsonValue.TRUE.equals(allow)) {
                    isAllow = true;
                }
                JsonValue deny = (JsonValue)privilegeValueObj.get((Object)"deny");
                boolean isDeny = false;
                Set<LocalRestriction> denyRestrictions = Collections.emptySet();
                if (deny instanceof JsonObject) {
                    isDeny = true;
                    denyRestrictions = this.toLocalRestrictions((JsonObject)deny, srMap, vf);
                } else if (JsonValue.TRUE.equals(deny)) {
                    isDeny = true;
                }
                if (!isAllow && !isDeny) continue;
                LocalPrivilege lp = privilegeToLocalPrivilegesMap.computeIfAbsent(privilegeName, LocalPrivilege::new);
                if (isAllow) {
                    lp.setAllow(true);
                    lp.setAllowRestrictions(allowRestrictions);
                }
                if (!isDeny) continue;
                lp.setDeny(true);
                lp.setDenyRestrictions(denyRestrictions);
            }
        }
        contentCreator.createAce(principalID, new ArrayList<LocalPrivilege>(privilegeToLocalPrivilegesMap.values()), order);
    }

    protected Map<String, RestrictionDefinition> toSrMap(Node parentNode) throws RepositoryException {
        HashMap<String, RestrictionDefinition> supportedRestrictionsMap = new HashMap<String, RestrictionDefinition>();
        RestrictionProvider compositeRestrictionProvider = null;
        HashSet<RestrictionProvider> restrictionProviders = new HashSet<RestrictionProvider>();
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            BundleContext bundleContext = bundle.getBundleContext();
            Collection serviceReferences = null;
            try {
                Object serviceReference2;
                serviceReferences = bundleContext.getServiceReferences(RestrictionProvider.class, null);
                for (Object serviceReference2 : serviceReferences) {
                    RestrictionProvider service = (RestrictionProvider)bundleContext.getService((ServiceReference)serviceReference2);
                    restrictionProviders.add(service);
                }
                compositeRestrictionProvider = CompositeRestrictionProvider.newInstance(restrictionProviders);
                Set supportedRestrictions = compositeRestrictionProvider.getSupportedRestrictions(parentNode.getPath());
                serviceReference2 = supportedRestrictions.iterator();
                while (serviceReference2.hasNext()) {
                    RestrictionDefinition restrictionDefinition = (RestrictionDefinition)serviceReference2.next();
                    supportedRestrictionsMap.put(restrictionDefinition.getName(), restrictionDefinition);
                }
            }
            catch (InvalidSyntaxException e) {
                throw new RepositoryException((Throwable)e);
            }
            finally {
                if (serviceReferences != null) {
                    for (ServiceReference serviceReference : serviceReferences) {
                        bundleContext.ungetService(serviceReference);
                    }
                }
            }
        }
        return supportedRestrictionsMap;
    }

    protected Set<LocalRestriction> toLocalRestrictions(JsonObject allowOrDenyObj, Map<String, RestrictionDefinition> srMap, ValueFactory vf) throws RepositoryException {
        HashSet<LocalRestriction> restrictions = new HashSet<LocalRestriction>();
        for (Map.Entry restrictionEntry : allowOrDenyObj.entrySet()) {
            Value v;
            int size;
            JsonArray jsonArray;
            String restrictionName = (String)restrictionEntry.getKey();
            RestrictionDefinition rd = srMap.get(restrictionName);
            if (rd == null) {
                throw new JsonException("Invalid or not supported restriction name was supplied: " + restrictionName);
            }
            boolean multival = rd.getRequiredType().isArray();
            int restrictionType = rd.getRequiredType().tag();
            LocalRestriction lr = null;
            JsonValue jsonValue = (JsonValue)restrictionEntry.getValue();
            if (multival) {
                if (jsonValue.getValueType() == JsonValue.ValueType.ARRAY) {
                    jsonArray = (JsonArray)jsonValue;
                    size = jsonArray.size();
                    Value[] values = new Value[size];
                    for (int i = 0; i < size; ++i) {
                        values[i] = this.toValue(vf, (JsonValue)jsonArray.get(i), restrictionType);
                    }
                    lr = new LocalRestriction(restrictionName, values);
                } else {
                    v = this.toValue(vf, jsonValue, restrictionType);
                    lr = new LocalRestriction(restrictionName, new Value[]{v});
                }
            } else if (jsonValue.getValueType() == JsonValue.ValueType.ARRAY) {
                jsonArray = (JsonArray)jsonValue;
                size = jsonArray.size();
                if (size == 1) {
                    Value v2 = this.toValue(vf, (JsonValue)jsonArray.get(0), restrictionType);
                    lr = new LocalRestriction(restrictionName, v2);
                } else if (size > 1) {
                    throw new JsonException("Unexpected multi value array data found for single-value restriction value for name: " + restrictionName);
                }
            } else {
                v = this.toValue(vf, jsonValue, restrictionType);
                lr = new LocalRestriction(restrictionName, v);
            }
            if (lr == null) continue;
            restrictions.add(lr);
        }
        return restrictions;
    }

    private Value toValue(ValueFactory factory, JsonValue jsonValue, int restrictionType) throws ValueFormatException {
        Value value = null;
        JsonValue.ValueType valueType = jsonValue.getValueType();
        switch (valueType) {
            case TRUE: {
                value = factory.createValue(false);
                break;
            }
            case FALSE: {
                value = factory.createValue(false);
                break;
            }
            case NUMBER: {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                if (jsonNumber.isIntegral()) {
                    value = factory.createValue(jsonNumber.longValue());
                    break;
                }
                value = factory.createValue(jsonNumber.doubleValue());
                break;
            }
            case STRING: {
                value = factory.createValue(((JsonString)jsonValue).getString(), restrictionType);
                break;
            }
        }
        return value;
    }

    static {
        ignoredNames.add("jcr:primaryType");
        ignoredNames.add("jcr:mixinTypes");
        ignoredNames.add("jcr:uuid");
        ignoredNames.add("jcr:baseVersion");
        ignoredNames.add("jcr:predecessors");
        ignoredNames.add("jcr:successors");
        ignoredNames.add("jcr:checkedOut");
        ignoredNames.add("jcr:created");
        ignoredPrincipalPropertyNames = new HashSet<String>();
        ignoredPrincipalPropertyNames.add("name");
        ignoredPrincipalPropertyNames.add("isgroup");
        ignoredPrincipalPropertyNames.add("members");
        ignoredPrincipalPropertyNames.add("dynamic");
        ignoredPrincipalPropertyNames.add("password");
    }
}

