/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.aggregator;

import java.util.Collection;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.Aggregate;
import org.apache.jackrabbit.vault.fs.api.Aggregator;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ArtifactSet;
import org.apache.jackrabbit.vault.fs.api.ArtifactType;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.Dumpable;
import org.apache.jackrabbit.vault.fs.api.ImportInfo;
import org.apache.jackrabbit.vault.fs.api.ItemFilterSet;
import org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import org.apache.jackrabbit.vault.fs.impl.DirectoryArtifact;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewSerializer;
import org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import org.apache.jackrabbit.vault.fs.spi.ACLManagement;
import org.apache.jackrabbit.vault.fs.spi.ServiceProviderFactory;
import org.apache.jackrabbit.vault.util.PathUtil;

public class GenericAggregator
implements Aggregator,
Dumpable {
    private String name;
    private boolean fullCoverage = false;
    private final ItemFilterSet contentFilter = new ItemFilterSet();
    private final ItemFilterSet matchFilter = new ItemFilterSet();
    private boolean isDefault = false;
    private ACLManagement aclManagement;

    private ACLManagement getAclManagement() {
        if (this.aclManagement == null) {
            this.aclManagement = ServiceProviderFactory.getProvider().getACLManagement();
        }
        return this.aclManagement;
    }

    @Override
    public boolean hasFullCoverage() {
        return this.fullCoverage;
    }

    public void setHasFullCoverage(String hasFullCoverage) {
        this.fullCoverage = Boolean.valueOf(hasFullCoverage);
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public void setIsDefault(String aDefault) {
        this.isDefault = Boolean.valueOf(aDefault);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFullCoverage(String fullCoverage) {
        this.fullCoverage = Boolean.valueOf(fullCoverage);
    }

    public ItemFilterSet getContentFilter() {
        return this.contentFilter;
    }

    public ItemFilterSet getMatchFilter() {
        return this.matchFilter;
    }

    @Override
    public boolean includes(Node root, Node node, String path) throws RepositoryException {
        if (path == null) {
            path = node.getPath();
        }
        return this.contentFilter.contains((Item)node, path, PathUtil.getDepth(path) - root.getDepth());
    }

    @Override
    public boolean matches(Node node, String path) throws RepositoryException {
        return this.matchFilter.contains((Item)node, path, 0);
    }

    @Override
    public boolean includes(Node root, Node parent, Property property, String path) throws RepositoryException {
        if (path == null) {
            path = property.getPath();
        }
        return this.contentFilter.contains((Item)property, path, PathUtil.getDepth(path) - root.getDepth());
    }

    @Override
    public ArtifactSet createArtifacts(Aggregate aggregate) throws RepositoryException {
        ArtifactSetImpl artifacts = new ArtifactSetImpl();
        artifacts.setCoverage(this.getContentFilter());
        ArtifactType type = ArtifactType.PRIMARY;
        String name = aggregate.getName();
        String ext = ".xml";
        DirectoryArtifact parent = null;
        if (!this.hasFullCoverage()) {
            parent = new DirectoryArtifact(name);
            artifacts.add(parent);
            name = "";
            ext = ".content.xml";
            if ("nt:folder".equals(aggregate.getNode().getPrimaryNodeType().getName()) && aggregate.getNode().getMixinNodeTypes().length == 0) {
                return artifacts;
            }
        }
        DocViewSerializer ser = new DocViewSerializer(aggregate);
        artifacts.add((Artifact)parent, name, ext, type, ser, 0L);
        Collection<Property> bins = aggregate.getBinaries();
        if (bins != null && !bins.isEmpty()) {
            int pathLen;
            if (this.hasFullCoverage()) {
                assert (parent == null);
                parent = new DirectoryArtifact(aggregate.getName());
                artifacts.add(parent);
            }
            if ((pathLen = aggregate.getPath().length()) > 1) {
                ++pathLen;
            }
            for (Property prop : bins) {
                String relPath = prop.getPath().substring(pathLen);
                artifacts.add((Artifact)parent, relPath, ".binary", ArtifactType.BINARY, prop, 0L);
            }
        }
        return artifacts;
    }

    @Override
    public ImportInfo remove(Node node, boolean recursive, boolean trySave) throws RepositoryException {
        if (this.fullCoverage && !recursive) {
            throw new RepositoryException("Unable to remove content since aggregation has children and recursive is not set.");
        }
        ImportInfoImpl info = new ImportInfoImpl();
        info.onDeleted(node.getPath());
        Node parent = node.getParent();
        if (this.getAclManagement().isACLNode(node)) {
            this.getAclManagement().clearACL(parent);
        } else {
            node.remove();
        }
        if (trySave) {
            parent.getSession().save();
        }
        return info;
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, this.getClass().getSimpleName());
        ctx.indent(isLast);
        ctx.printf(false, "name: %s", this.getName());
        ctx.printf(false, "fullCoverage: %b", this.hasFullCoverage());
        ctx.printf(false, "default: %b", this.isDefault());
        ctx.println(false, "Content Filter");
        ctx.indent(false);
        this.getContentFilter().dump(ctx, true);
        ctx.outdent();
        ctx.println(true, "Match Filter");
        ctx.indent(true);
        this.getMatchFilter().dump(ctx, true);
        ctx.outdent();
        ctx.outdent();
    }
}

