/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.operation.TransientOperation;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddNode
extends TransientOperation {
    private static Logger log = LoggerFactory.getLogger(AddNode.class);
    private final NodeId parentId;
    private final NodeState parentState;
    private final Name nodeName;
    private final Name nodeTypeName;
    private final String uuid;
    private final List<ItemState> addedStates = new ArrayList<ItemState>();

    private AddNode(NodeState parentState, Name nodeName, Name nodeTypeName, String uuid) throws RepositoryException {
        this(parentState, nodeName, nodeTypeName, uuid, 46);
    }

    AddNode(NodeState parentState, Name nodeName, Name nodeTypeName, String uuid, int options) throws RepositoryException {
        super(options);
        this.parentId = parentState.getNodeId();
        this.parentState = parentState;
        this.nodeName = nodeName;
        this.nodeTypeName = nodeTypeName;
        this.uuid = uuid;
        this.addAffectedItemState(parentState);
    }

    @Override
    public void accept(OperationVisitor visitor) throws LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        assert (this.status == 0);
        visitor.visit(this);
    }

    @Override
    public void persisted() throws RepositoryException {
        assert (this.status == 0);
        this.status = 1;
        this.parentState.getHierarchyEntry().complete(this);
    }

    @Override
    public void undo() throws RepositoryException {
        assert (this.status == 0);
        this.status = 2;
        this.parentState.getHierarchyEntry().complete(this);
    }

    public NodeId getParentId() {
        return this.parentId;
    }

    public NodeState getParentState() {
        return this.parentState;
    }

    public Name getNodeName() {
        return this.nodeName;
    }

    public Name getNodeTypeName() {
        return this.nodeTypeName;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void addedState(List<ItemState> newStates) {
        this.addedStates.addAll(newStates);
    }

    public List<ItemState> getAddedStates() {
        return this.addedStates;
    }

    public static Operation create(NodeState parentState, Name nodeName, Name nodeTypeName, String uuid) throws RepositoryException {
        AddNode.assertChildNodeEntries(parentState);
        AddNode an = new AddNode(parentState, nodeName, nodeTypeName, uuid);
        return an;
    }
}

