/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.analyser;

import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.extension.apiregions.analyser.AbstractApiRegionsAnalyserTask;
import org.apache.sling.feature.extension.apiregions.api.ApiExport;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;

public class CheckApiRegionsDuplicates
extends AbstractApiRegionsAnalyserTask {
    public String getId() {
        return "api-regions-duplicates";
    }

    public String getName() {
        return "Api Regions duplicates analyser task";
    }

    @Override
    protected void execute(ApiRegions apiRegions, AnalyserTaskContext ctx) throws Exception {
        for (int i = 0; i < apiRegions.listRegions().size(); ++i) {
            ApiRegion sourceRegion = apiRegions.listRegions().get(i);
            List<ApiRegion> targetRegions = apiRegions.listRegions().subList(i + 1, apiRegions.listRegions().size());
            for (ApiRegion targetRegion : targetRegions) {
                Set<String> intersection;
                if (sourceRegion.equals(targetRegion) || (intersection = CheckApiRegionsDuplicates.calculateIntersection(sourceRegion, targetRegion)).isEmpty()) continue;
                Formatter formatter = new Formatter();
                formatter.format("Regions '%s' and '%s' defined in feature '%s' declare both %s package(s):%n", sourceRegion.getName(), targetRegion.getName(), ctx.getFeature().getId(), intersection.size());
                intersection.forEach(api -> formatter.format(" * %s%n", api));
                ctx.reportError(formatter.toString());
                formatter.close();
            }
        }
    }

    private static Set<String> calculateIntersection(ApiRegion source, ApiRegion target) {
        HashSet<String> intersection = new HashSet<String>();
        for (ApiExport packageName : source.listExports()) {
            if (target.getExportByName(packageName.getName()) == null) continue;
            intersection.add(packageName.getName());
        }
        return intersection;
    }
}

