/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.commons.nodetype.NodeTypeStorage;

public class NodeTypeCache {
    private static final Map<RepositoryService, Map<String, NodeTypeCache>> CACHES_PER_SERVICE = new WeakHashMap<RepositoryService, Map<String, NodeTypeCache>>();
    private final Map<Name, QNodeTypeDefinition> nodeTypes = new HashMap<Name, QNodeTypeDefinition>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeTypeCache getInstance(RepositoryService service, String userId) {
        ReferenceMap caches;
        if (userId == null) {
            return new NodeTypeCache();
        }
        ReferenceMap referenceMap = CACHES_PER_SERVICE;
        synchronized (referenceMap) {
            caches = CACHES_PER_SERVICE.get(service);
            if (caches == null) {
                caches = new ReferenceMap(0, 1);
                CACHES_PER_SERVICE.put(service, (Map<String, NodeTypeCache>)caches);
            }
        }
        referenceMap = caches;
        synchronized (referenceMap) {
            NodeTypeCache cache = (NodeTypeCache)caches.get(userId);
            if (cache == null) {
                cache = new NodeTypeCache();
                caches.put(userId, cache);
            }
            return cache;
        }
    }

    private NodeTypeCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<QNodeTypeDefinition> getAllDefinitions(NodeTypeStorage storage) throws RepositoryException {
        HashMap<Name, QNodeTypeDefinition> allNts = new HashMap<Name, QNodeTypeDefinition>();
        Iterator it = storage.getAllDefinitions();
        while (it.hasNext()) {
            QNodeTypeDefinition def = (QNodeTypeDefinition)it.next();
            allNts.put(def.getName(), def);
        }
        Map<Name, QNodeTypeDefinition> map = this.nodeTypes;
        synchronized (map) {
            this.nodeTypes.clear();
            this.nodeTypes.putAll(allNts);
        }
        return allNts.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<QNodeTypeDefinition> getDefinitions(NodeTypeStorage storage, Name[] nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
        ArrayList<QNodeTypeDefinition> nts = new ArrayList<QNodeTypeDefinition>();
        ArrayList<Name> missing = null;
        Map<Name, QNodeTypeDefinition> map = this.nodeTypes;
        synchronized (map) {
            for (int i = 0; i < nodeTypeNames.length; ++i) {
                QNodeTypeDefinition def = this.nodeTypes.get(nodeTypeNames[i]);
                if (def == null) {
                    if (missing == null) {
                        missing = new ArrayList<Name>();
                    }
                    missing.add(nodeTypeNames[i]);
                    continue;
                }
                nts.add(def);
            }
        }
        if (missing != null) {
            Name[] ntNames = missing.toArray(new Name[missing.size()]);
            Iterator it = storage.getDefinitions(ntNames);
            Map<Name, QNodeTypeDefinition> map2 = this.nodeTypes;
            synchronized (map2) {
                while (it.hasNext()) {
                    QNodeTypeDefinition def = (QNodeTypeDefinition)it.next();
                    nts.add(def);
                    this.nodeTypes.put(def.getName(), def);
                }
            }
        }
        return nts.iterator();
    }

    public void registerNodeTypes(NodeTypeStorage storage, QNodeTypeDefinition[] nodeTypeDefs, boolean allowUpdate) throws RepositoryException {
        storage.registerNodeTypes(nodeTypeDefs, allowUpdate);
    }

    public void unregisterNodeTypes(NodeTypeStorage storage, Name[] nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
        storage.unregisterNodeTypes(nodeTypeNames);
    }

    public NodeTypeStorage wrap(final NodeTypeStorage storage) {
        return new NodeTypeStorage(){

            public Iterator<QNodeTypeDefinition> getAllDefinitions() throws RepositoryException {
                return NodeTypeCache.this.getAllDefinitions(storage);
            }

            public Iterator<QNodeTypeDefinition> getDefinitions(Name[] nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
                return NodeTypeCache.this.getDefinitions(storage, nodeTypeNames);
            }

            public void registerNodeTypes(QNodeTypeDefinition[] nodeTypeDefs, boolean allowUpdate) throws RepositoryException {
                NodeTypeCache.this.registerNodeTypes(storage, nodeTypeDefs, allowUpdate);
            }

            public void unregisterNodeTypes(Name[] nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
                NodeTypeCache.this.unregisterNodeTypes(storage, nodeTypeNames);
            }
        };
    }
}

