/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.impl.felix.utils.collections;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DictionaryAsMap<U, V>
extends AbstractMap<U, V> {
    private Dictionary<U, V> dict;

    public DictionaryAsMap(Dictionary<U, V> dict) {
        this.dict = dict;
    }

    @Override
    public Set<Map.Entry<U, V>> entrySet() {
        return new AbstractSet<Map.Entry<U, V>>(){

            @Override
            public Iterator<Map.Entry<U, V>> iterator() {
                final Enumeration e = DictionaryAsMap.this.dict.keys();
                return new Iterator<Map.Entry<U, V>>(){
                    private U key;

                    @Override
                    public boolean hasNext() {
                        return e.hasMoreElements();
                    }

                    @Override
                    public Map.Entry<U, V> next() {
                        this.key = e.nextElement();
                        return new KeyEntry(this.key);
                    }

                    @Override
                    public void remove() {
                        if (this.key == null) {
                            throw new IllegalStateException();
                        }
                        DictionaryAsMap.this.dict.remove(this.key);
                    }
                };
            }

            @Override
            public int size() {
                return DictionaryAsMap.this.dict.size();
            }
        };
    }

    @Override
    public V put(U key, V value) {
        return this.dict.put(key, value);
    }

    class KeyEntry
    implements Map.Entry<U, V> {
        private final U key;

        KeyEntry(U key) {
            this.key = key;
        }

        @Override
        public U getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return DictionaryAsMap.this.dict.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return DictionaryAsMap.this.put(this.key, value);
        }
    }
}

