/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;
import org.jetbrains.annotations.NotNull;

public class NodeTypesEntryHandler
extends AbstractRegexEntryHandler {
    public NodeTypesEntryHandler() {
        super("/META-INF/vault/.*\\.cnd");
    }

    public static NodeTypesEntryHandler forCndPattern(@NotNull Pattern pattern) {
        String originalCndRegex = pattern.pattern();
        if (originalCndRegex.startsWith("^")) {
            originalCndRegex = originalCndRegex.substring(1);
        }
        if (originalCndRegex.startsWith("/")) {
            originalCndRegex = originalCndRegex.substring(1);
        }
        return new NodeTypesEntryHandler(Pattern.compile("/jcr_root/" + originalCndRegex));
    }

    private NodeTypesEntryHandler(@NotNull Pattern pattern) {
        super(pattern);
    }

    @Override
    public void handle(@NotNull String path, @NotNull Archive archive, @NotNull Archive.Entry entry, @NotNull ContentPackage2FeatureModelConverter converter) throws IOException, ConverterException {
        try (InputStreamReader cndStatements = new InputStreamReader(Objects.requireNonNull(archive.openInputStream(entry)));){
            converter.getAclManager().addNodetypeRegistration(IOUtils.toString((Reader)cndStatements));
        }
    }
}

