/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.json;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.felix.cm.json.ConfigurationResource;
import org.apache.felix.cm.json.ConfigurationWriter;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionState;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.MatchingRequirement;
import org.apache.sling.feature.Prototype;
import org.apache.sling.feature.io.json.ManifestUtils;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class FeatureJSONWriter {
    private final JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));

    public static void write(Writer writer, Feature feature) throws IOException {
        FeatureJSONWriter w = new FeatureJSONWriter();
        w.writeFeature(writer, feature);
    }

    private final JsonGenerator newGenerator(Writer writer) {
        return this.generatorFactory.createGenerator((Writer)new FilterWriter(writer){

            @Override
            public void close() throws IOException {
                super.flush();
            }
        });
    }

    private void writeBundles(JsonGenerator generator, Bundles bundles, Configurations allConfigs) {
        if (!bundles.isEmpty()) {
            generator.writeStartArray("bundles");
            for (Artifact artifact : bundles) {
                Configurations cfgs = new Configurations();
                for (Configuration cfg : allConfigs) {
                    String artifactProp = (String)cfg.getProperties().get(":configurator:feature-service.bundleLocation");
                    if (!artifact.getId().toMvnId().equals(artifactProp)) continue;
                    cfgs.add(cfg);
                }
                Map<String, String> md = artifact.getMetadata();
                if (md.isEmpty() && cfgs.isEmpty()) {
                    generator.write(artifact.getId().toMvnId());
                    continue;
                }
                generator.writeStartObject();
                generator.write("id", artifact.getId().toMvnId());
                String runmodes = md.remove("runmodes");
                if (runmodes instanceof String) {
                    md.put("run-modes", runmodes);
                }
                for (Map.Entry<String, String> me : md.entrySet()) {
                    generator.write(me.getKey(), me.getValue());
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    private void writeConfigurations(JsonGenerator generator, Configurations cfgs) throws IOException {
        if (cfgs.isEmpty()) {
            return;
        }
        generator.writeKey("configurations");
        ConfigurationWriter cfgWriter = org.apache.felix.cm.json.Configurations.buildWriter().build(generator);
        ConfigurationResource rsrc = new ConfigurationResource();
        for (Configuration cfg : cfgs) {
            Hashtable properties;
            if (cfg.getProperties() instanceof Hashtable && cfg.getProperties().get(":configurator:feature-service.bundleLocation") == null) {
                properties = (Hashtable)cfg.getProperties();
            } else {
                properties = org.apache.felix.cm.json.Configurations.newConfiguration();
                for (String name : Collections.list(cfg.getProperties().keys())) {
                    if (":configurator:feature-service.bundleLocation".equals(name)) continue;
                    properties.put(name, cfg.getProperties().get(name));
                }
            }
            rsrc.getConfigurations().put(cfg.getPid(), properties);
        }
        cfgWriter.writeConfigurationResource(rsrc);
    }

    private void writeVariables(JsonGenerator generator, Map<String, String> vars) {
        if (!vars.isEmpty()) {
            generator.writeStartObject("variables");
            for (Map.Entry<String, String> entry : vars.entrySet()) {
                String val = entry.getValue();
                if (val != null) {
                    generator.write(entry.getKey(), val);
                    continue;
                }
                generator.writeNull(entry.getKey());
            }
            generator.writeEnd();
        }
    }

    private void writeFrameworkProperties(JsonGenerator generator, Map<String, String> props) {
        if (!props.isEmpty()) {
            generator.writeStartObject("framework-properties");
            for (Map.Entry<String, String> entry : props.entrySet()) {
                generator.write(entry.getKey(), entry.getValue());
            }
            generator.writeEnd();
        }
    }

    private void writeExtensions(JsonGenerator generator, List<Extension> extensions, Configurations allConfigs) throws IOException {
        for (Extension ext : extensions) {
            this.writeExtension(generator, ext, allConfigs);
        }
    }

    private void writeExtension(JsonGenerator generator, Extension ext, Configurations allConfigs) throws IOException {
        String state;
        switch (ext.getState()) {
            case OPTIONAL: {
                state = "false";
                break;
            }
            case REQUIRED: {
                state = "true";
                break;
            }
            default: {
                state = ext.getState().name();
            }
        }
        String key = ext.getName().concat(":").concat(ext.getType().name()).concat("|").concat(state);
        if (ext.getType() == ExtensionType.JSON) {
            generator.write(key, (JsonValue)ext.getJSONStructure());
        } else if (ext.getType() == ExtensionType.TEXT) {
            generator.writeStartArray(key);
            for (String line : ext.getText().split("\n")) {
                generator.write(line);
            }
            generator.writeEnd();
        } else {
            generator.writeStartArray(key);
            for (Artifact artifact : ext.getArtifacts()) {
                Configurations artifactCfgs = new Configurations();
                for (Configuration configuration : allConfigs) {
                    String artifactProp = (String)configuration.getProperties().get(":configurator:feature-service.bundleLocation");
                    if (!artifact.getId().toMvnId().equals(artifactProp)) continue;
                    artifactCfgs.add(configuration);
                }
                if (artifact.getMetadata().isEmpty() && artifactCfgs.isEmpty()) {
                    generator.write(artifact.getId().toMvnId());
                    continue;
                }
                generator.writeStartObject();
                generator.write("id", artifact.getId().toMvnId());
                for (Map.Entry entry : artifact.getMetadata().entrySet()) {
                    generator.write((String)entry.getKey(), (String)entry.getValue());
                }
                this.writeConfigurations(generator, artifactCfgs);
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    private void writeProperty(JsonGenerator generator, String key, String value) {
        if (value != null) {
            generator.write(key, value);
        }
    }

    private <T> void writeList(JsonGenerator generator, String name, Collection<T> values) {
        if (!values.isEmpty()) {
            generator.writeStartArray(name);
            for (T value : values) {
                generator.write(value.toString());
            }
            generator.writeEnd();
        }
    }

    private void writePrototype(JsonGenerator generator, Prototype inc) {
        if (inc == null) {
            return;
        }
        if (inc.getArtifactExtensionRemovals().isEmpty() && inc.getBundleRemovals().isEmpty() && inc.getConfigurationRemovals().isEmpty() && inc.getFrameworkPropertiesRemovals().isEmpty() && inc.getRequirementRemovals().isEmpty() && inc.getCapabilityRemovals().isEmpty()) {
            generator.write("prototype", inc.getId().toMvnId());
        } else {
            generator.writeStartObject("prototype");
            this.writeProperty(generator, "id", inc.getId().toMvnId());
            generator.writeStartObject("removals");
            if (!inc.getArtifactExtensionRemovals().isEmpty() || inc.getExtensionRemovals().isEmpty()) {
                generator.writeStartArray("extensions");
                for (String string : inc.getExtensionRemovals()) {
                    generator.write(string);
                }
                for (Map.Entry entry : inc.getArtifactExtensionRemovals().entrySet()) {
                    generator.writeStartObject();
                    this.writeList(generator, (String)entry.getKey(), (Collection)entry.getValue());
                    generator.writeEnd();
                }
                generator.writeEnd();
            }
            this.writeList(generator, "configurations", inc.getConfigurationRemovals());
            this.writeList(generator, "bundles", inc.getBundleRemovals());
            this.writeList(generator, "framework-properties", inc.getFrameworkPropertiesRemovals());
            this.writeRequirements(generator, inc.getRequirementRemovals());
            this.writeCapabilities(generator, inc.getCapabilityRemovals());
            generator.writeEnd().writeEnd();
        }
    }

    private void writeRequirements(JsonGenerator generator, List<MatchingRequirement> requirements) {
        if (requirements.isEmpty()) {
            return;
        }
        generator.writeStartArray("requirements");
        for (Requirement requirement : requirements) {
            generator.writeStartObject();
            this.writeProperty(generator, "namespace", requirement.getNamespace());
            if (!requirement.getAttributes().isEmpty()) {
                generator.writeStartObject("attributes");
                requirement.getAttributes().forEach((key, value) -> ManifestUtils.marshalAttribute(key, value, (arg_0, arg_1) -> ((JsonGenerator)generator).write(arg_0, arg_1)));
                generator.writeEnd();
            }
            if (!requirement.getDirectives().isEmpty()) {
                generator.writeStartObject("directives");
                requirement.getDirectives().forEach((key, value) -> ManifestUtils.marshalDirective(key, value, (arg_0, arg_1) -> ((JsonGenerator)generator).write(arg_0, arg_1)));
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    private void writeCapabilities(JsonGenerator generator, List<Capability> capabilities) {
        if (capabilities.isEmpty()) {
            return;
        }
        generator.writeStartArray("capabilities");
        for (Capability cap : capabilities) {
            generator.writeStartObject();
            this.writeProperty(generator, "namespace", cap.getNamespace());
            if (!cap.getAttributes().isEmpty()) {
                generator.writeStartObject("attributes");
                cap.getAttributes().forEach((key, value) -> ManifestUtils.marshalAttribute(key, value, (arg_0, arg_1) -> ((JsonGenerator)generator).write(arg_0, arg_1)));
                generator.writeEnd();
            }
            if (!cap.getDirectives().isEmpty()) {
                generator.writeStartObject("directives");
                cap.getDirectives().forEach((key, value) -> ManifestUtils.marshalDirective(key, value, (arg_0, arg_1) -> ((JsonGenerator)generator).write(arg_0, arg_1)));
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    private void writeFeature(Writer writer, Feature feature) throws IOException {
        JsonGenerator generator = this.newGenerator(writer);
        generator.writeStartObject();
        this.writeFeatureId(generator, feature);
        if (feature.isFinal()) {
            generator.write("final", true);
        }
        if (feature.isComplete()) {
            generator.write("complete", true);
        }
        this.writeProperty(generator, "title", feature.getTitle());
        this.writeProperty(generator, "description", feature.getDescription());
        this.writeProperty(generator, "vendor", feature.getVendor());
        this.writeProperty(generator, "license", feature.getLicense());
        this.writeVariables(generator, feature.getVariables());
        this.writePrototype(generator, feature.getPrototype());
        this.writeRequirements(generator, feature.getRequirements());
        this.writeCapabilities(generator, feature.getCapabilities());
        this.writeBundles(generator, feature.getBundles(), feature.getConfigurations());
        Configurations cfgs = new Configurations();
        for (Configuration cfg : feature.getConfigurations()) {
            String artifactProp = (String)cfg.getProperties().get(":configurator:feature-service.bundleLocation");
            if (artifactProp != null) continue;
            cfgs.add(cfg);
        }
        this.writeConfigurations(generator, cfgs);
        this.writeFrameworkProperties(generator, feature.getFrameworkProperties());
        if (feature.getExtensions().getByName("feature-internal-data") != null) {
            throw new IOException("Feature must not contain internal data extension");
        }
        this.writeInternalData(generator, feature);
        this.writeExtensions(generator, feature.getExtensions(), feature.getConfigurations());
        generator.writeEnd().close();
    }

    private void writeFeatureId(JsonGenerator generator, Feature feature) {
        this.writeProperty(generator, "id", feature.getId().toMvnId());
    }

    private void writeInternalData(JsonGenerator generator, Feature feature) throws IOException {
        Map<String, Object> metadata;
        LinkedHashMap output = new LinkedHashMap();
        if (!feature.getFrameworkProperties().isEmpty()) {
            LinkedHashMap<String, Map<String, Object>> fwkMetadata = new LinkedHashMap<String, Map<String, Object>>();
            for (String fwkPropName : feature.getFrameworkProperties().keySet()) {
                metadata = feature.getFrameworkPropertyMetadata(fwkPropName);
                if (metadata.isEmpty()) continue;
                fwkMetadata.put(fwkPropName, metadata);
            }
            if (!fwkMetadata.isEmpty()) {
                output.put("framework-properties-metadata", fwkMetadata);
            }
        }
        if (!feature.getVariables().isEmpty()) {
            LinkedHashMap<String, Map<String, Object>> varMetadata = new LinkedHashMap<String, Map<String, Object>>();
            for (String varName : feature.getVariables().keySet()) {
                metadata = feature.getVariableMetadata(varName);
                if (metadata.isEmpty()) continue;
                varMetadata.put(varName, metadata);
            }
            if (!varMetadata.isEmpty()) {
                output.put("variables-metadata", varMetadata);
            }
        }
        if (!output.isEmpty()) {
            Extension ext = new Extension(ExtensionType.JSON, "feature-internal-data", ExtensionState.OPTIONAL);
            ext.setJSONStructure((JsonStructure)org.apache.felix.cm.json.Configurations.convertToJsonValue(output).asJsonObject());
            this.writeExtension(generator, ext, null);
        }
    }
}

