/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.analyser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;

public class CheckApiRegionsOrder
implements AnalyserTask {
    public String getId() {
        return "api-regions-check-order";
    }

    public String getName() {
        return "Api Regions check order analyser task";
    }

    public final void execute(AnalyserTaskContext ctx) throws Exception {
        String order = (String)ctx.getConfiguration().get("order");
        Feature feature = ctx.getFeature();
        if (feature == null) {
            this.reportError(ctx, "No feature found. Illegal Analyser State.");
            return;
        }
        if (order == null) {
            this.reportError(ctx, "This analyser task must be configured: " + this.getId() + " for feature " + feature.getId());
            this.reportError(ctx, "Must specify configuration key 'order'.");
            return;
        }
        String[] sl = order.split("[,]");
        ArrayList<String> prescribedOrder = new ArrayList<String>();
        for (String s : sl) {
            if ((s = s.trim()).length() <= 0) continue;
            prescribedOrder.add(s);
        }
        if (prescribedOrder.size() == 0) {
            this.reportError(ctx, "No regions declared in the 'order' configuration");
            return;
        }
        Extensions extensions = feature.getExtensions();
        Extension apiRegionsExtension = extensions.getByName("api-regions");
        if (apiRegionsExtension == null) {
            return;
        }
        String jsonRepresentation = apiRegionsExtension.getJSON();
        if (jsonRepresentation == null || jsonRepresentation.isEmpty()) {
            return;
        }
        try {
            int regionIdx = 0;
            ApiRegions apiRegions = ApiRegions.parse((JsonArray)apiRegionsExtension.getJSONStructure());
            for (ApiRegion region : apiRegions.listRegions()) {
                String name = region.getName();
                if (!prescribedOrder.contains(name)) {
                    this.reportError(ctx, "Region found with undeclared name: " + name);
                    return;
                }
                int prevIdx = regionIdx;
                if ((regionIdx = this.validateRegion(regionIdx, prescribedOrder, name)) >= 0) continue;
                this.reportError(ctx, "Region '" + name + "' appears in the wrong order. It appears after '" + (String)prescribedOrder.get(prevIdx) + "'. Order of regions should be " + prescribedOrder);
                return;
            }
        }
        catch (IOException e) {
            ctx.reportError("Invalid api regions");
        }
    }

    private int validateRegion(int regionIdx, List<String> order, String name) {
        for (int i = regionIdx; i < order.size(); ++i) {
            if (!name.equals(order.get(i))) continue;
            return i;
        }
        return -1;
    }

    private String getPrefix() {
        return this.getId() + ": ";
    }

    private void reportError(AnalyserTaskContext ctx, String err) {
        ctx.reportError(this.getPrefix() + err);
    }
}

