/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl.nodetype;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.jcr2spi.NamespaceStorage;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameParser;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.value.BinaryValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.StringValue;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.apache.jackrabbit.vault.util.StandaloneManagerProvider;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.GenericMetaInfDataValidator;
import org.apache.jackrabbit.vault.validation.spi.JcrPathValidator;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.DocViewPropertyValueFactory;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.JcrNodeTypeMetaData;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.JcrNodeTypeMetaDataImpl;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.NamespaceExceptionInNodeName;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.OnDemandRegisterNamespaceResolverWrapper;
import org.apache.jackrabbit.vault.validation.spi.util.NodeContextImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeTypeValidator
implements DocumentViewXmlValidator,
JcrPathValidator,
GenericMetaInfDataValidator {
    static final String MESSAGE_INVALID_CND_IN_PACKAGE = "Invalid CND file found in package at %s: %s. Cannot consider it for node type validation.";
    static final String MESSAGE_REGISTERED_CND_IN_PACKAGE = "CDN file %s registered for node type validation";
    static final String MESSAGE_INVALID_PROPERTY_VALUE = "Property %s does not have a valid value: %s";
    static final String MESSAGE_UNKNOWN_NODE_TYPE_OR_NAMESPACE = "%s Skip validation of nodes with that type/name";
    static final String MESSAGE_MISSING_PRIMARY_TYPE = "Mandatory jcr:primaryType missing on node '%s'";
    static final Value DUMMY_BINARY_VALUE = new BinaryValue("dummy binary");
    static final Value DUMMY_DATE_VALUE = new DateValue(Calendar.getInstance());
    static final Value DUMMY_STRING_VALUE = new StringValue("dummy string");
    private final WorkspaceFilter filter;
    private final ValidationMessageSeverity defaultSeverity;
    private final ValidationMessageSeverity severityForUnknownNodeTypes;
    private final ValidationMessageSeverity severityForDefaultNodeTypeViolations;
    private final DocViewPropertyValueFactory docViewPropertyValueFactory;
    private final StandaloneManagerProvider ntManagerProvider;
    private final Set<String> loggedUnknownNodeTypeMessages;
    @NotNull
    private final Name defaultType;
    private JcrNodeTypeMetaData currentNodeTypeMetaData;

    public NodeTypeValidator(boolean isIncremental, @NotNull WorkspaceFilter filter, @NotNull StandaloneManagerProvider ntManagerProvider, @NotNull Name defaultPrimaryNodeType, @NotNull ValidationMessageSeverity defaultSeverity, @NotNull ValidationMessageSeverity severityForUnknownNodeTypes, @NotNull ValidationMessageSeverity severityForDefaultNodeTypeViolations) throws ConstraintViolationException, NoSuchNodeTypeException {
        this.filter = filter;
        this.ntManagerProvider = ntManagerProvider;
        this.defaultType = defaultPrimaryNodeType;
        this.defaultSeverity = defaultSeverity;
        this.severityForUnknownNodeTypes = severityForUnknownNodeTypes;
        this.severityForDefaultNodeTypeViolations = severityForDefaultNodeTypeViolations;
        this.docViewPropertyValueFactory = new DocViewPropertyValueFactory();
        this.loggedUnknownNodeTypeMessages = new HashSet<String>();
        this.currentNodeTypeMetaData = JcrNodeTypeMetaDataImpl.createRoot(isIncremental, ntManagerProvider.getEffectiveNodeTypeProvider());
    }

    static String getDocViewNodeLabel(DocViewNode2 node) {
        StringBuilder sb = new StringBuilder(node.getName().toString());
        sb.append(" [").append(node.getPrimaryType().orElse("-"));
        if (!node.getMixinTypes().isEmpty()) {
            sb.append(" (").append(StringUtils.join((Iterable)node.getMixinTypes(), (String)", ")).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validateMetaInfData(@NotNull InputStream input, @NotNull Path filePath, @NotNull Path basePath) throws IOException {
        Set<ValidationMessage> set;
        InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
        try {
            this.ntManagerProvider.registerNodeTypes((Reader)reader);
            set = Collections.singleton(new ValidationMessage(ValidationMessageSeverity.INFO, String.format(MESSAGE_REGISTERED_CND_IN_PACKAGE, filePath)));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (RepositoryException | ParseException e) {
                return Collections.singleton(new ValidationMessage(this.defaultSeverity, String.format(MESSAGE_INVALID_CND_IN_PACKAGE, filePath, e.getMessage()), filePath, basePath, 0, 0, e));
            }
        }
        reader.close();
        return set;
    }

    @Override
    public boolean shouldValidateMetaInfData(@NotNull Path filePath, @NotNull Path basePath) {
        return filePath.getFileName().toString().endsWith(".cnd");
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validate(@NotNull DocViewNode2 node, @NotNull NodeContext nodeContext, boolean isRoot) {
        Optional primaryType = node.getPrimaryType();
        if (!primaryType.isPresent()) {
            if (this.filter.contains(nodeContext.getNodePath()) && !node.getProperties().isEmpty()) {
                return Collections.singleton(new ValidationMessage(this.defaultSeverity, String.format(MESSAGE_MISSING_PRIMARY_TYPE, nodeContext.getNodePath())));
            }
            return null;
        }
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        messages.addAll(this.getOrCreateNewNode(nodeContext, false, this.isImplicit(nodeContext.getNodePath()), false, (String)primaryType.get(), node.getMixinTypes().toArray(new String[0])));
        for (DocViewProperty2 property : node.getProperties()) {
            try {
                messages.addAll(this.addProperty(nodeContext, property.getName().toString(), property.isMultiValue(), this.docViewPropertyValueFactory.getValues(property)));
            }
            catch (ValueFormatException e) {
                messages.add(new ValidationMessage(this.defaultSeverity, String.format(MESSAGE_INVALID_PROPERTY_VALUE, property.getName(), e.getLocalizedMessage())));
            }
        }
        return messages;
    }

    private boolean isImplicit(String path) {
        return !this.filter.contains(path);
    }

    private Collection<ValidationMessage> addProperty(NodeContext nodeContext, String propertyName, boolean isMultiValue, Value ... values) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        try {
            messages.addAll(this.currentNodeTypeMetaData.addProperty(nodeContext, this.ntManagerProvider.getNamePathResolver(), this.ntManagerProvider.getEffectiveNodeTypeProvider(), this.ntManagerProvider.getNodeTypeDefinitionProvider(), this.ntManagerProvider.getItemDefinitionProvider(), this.defaultSeverity, this.severityForDefaultNodeTypeViolations, propertyName, isMultiValue, values));
        }
        catch (NamespaceException | NoSuchNodeTypeException e) {
            if (!this.loggedUnknownNodeTypeMessages.contains(e.getMessage())) {
                messages.add(new ValidationMessage(this.severityForUnknownNodeTypes, String.format(MESSAGE_UNKNOWN_NODE_TYPE_OR_NAMESPACE, e.getMessage()), nodeContext, e));
                this.loggedUnknownNodeTypeMessages.add(e.getMessage());
            }
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Could not validate property against node types: " + e.getMessage(), e);
        }
        return messages;
    }

    private Optional<JcrNodeTypeMetaData> getNode(String nodePath) {
        try {
            return this.currentNodeTypeMetaData.getNode(this.ntManagerProvider.getNamePathResolver(), nodePath);
        }
        catch (NamespaceException e) {
            return Optional.empty();
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Could not get node types for path '" + nodePath + "': " + e.getMessage(), e);
        }
    }

    @NotNull
    private Collection<ValidationMessage> getOrCreateNewNode(NodeContext nodeContext, boolean isFolder, boolean isImplicit, boolean isFallbackPrimaryType, String primaryType, String ... mixinTypes) {
        Optional<JcrNodeTypeMetaData> node = this.getNode(nodeContext.getNodePath());
        if (node.isPresent()) {
            this.currentNodeTypeMetaData = node.get();
            try {
                this.currentNodeTypeMetaData.setNodeTypes(this.ntManagerProvider.getNameResolver(), this.ntManagerProvider.getEffectiveNodeTypeProvider(), isFallbackPrimaryType, primaryType, mixinTypes);
            }
            catch (NamespaceException | NoSuchNodeTypeException e) {
                this.currentNodeTypeMetaData.setUnknownNodeTypes();
                if (!this.loggedUnknownNodeTypeMessages.contains(e.getMessage())) {
                    this.loggedUnknownNodeTypeMessages.add(e.getMessage());
                    return Collections.singleton(new ValidationMessage(this.severityForUnknownNodeTypes, String.format(MESSAGE_UNKNOWN_NODE_TYPE_OR_NAMESPACE, e.getMessage(), nodeContext)));
                }
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Could not create node type information for path '" + nodeContext.getNodePath() + "': " + e.getMessage(), e);
            }
            return Collections.emptyList();
        }
        return this.createNewNode(nodeContext, isFolder, isImplicit, primaryType, mixinTypes);
    }

    @NotNull
    private Collection<ValidationMessage> createNewNode(NodeContext nodeContext, boolean isFolder, boolean isImplicit, String primaryType, String ... mixinTypes) {
        ArrayList<ValidationMessage> messages;
        block8: {
            messages = new ArrayList<ValidationMessage>();
            String nodePath = nodeContext.getNodePath();
            if (nodePath.equals("/") && !isImplicit) {
                throw new IllegalStateException("Can not create non implicit root node with path \"/\"");
            }
            String parentNodePath = Text.getRelativeParent((String)nodePath, (int)1);
            String nodeName = Text.getName((String)nodePath);
            try {
                JcrNodeTypeMetaData parentNode = this.currentNodeTypeMetaData.getOrCreateNode(this.ntManagerProvider.getNamePathResolver(), nodeContext, parentNodePath);
                try {
                    if (isImplicit) {
                        this.currentNodeTypeMetaData = !nodePath.equals("/") ? parentNode.addImplicitChildNode(this.ntManagerProvider.getNameResolver(), this.ntManagerProvider.getEffectiveNodeTypeProvider(), this.ntManagerProvider.getNodeTypeDefinitionProvider(), this.ntManagerProvider.getItemDefinitionProvider(), nodeContext, this.defaultType) : parentNode;
                        break block8;
                    }
                    this.currentNodeTypeMetaData = parentNode.addChildNode(this.ntManagerProvider.getNameResolver(), this.ntManagerProvider.getEffectiveNodeTypeProvider(), this.ntManagerProvider.getNodeTypeDefinitionProvider(), this.ntManagerProvider.getItemDefinitionProvider(), nodeContext, primaryType, mixinTypes);
                }
                catch (NamespaceException | NoSuchNodeTypeException e) {
                    if (!this.loggedUnknownNodeTypeMessages.contains(e.getMessage())) {
                        messages.add(new ValidationMessage(this.severityForUnknownNodeTypes, String.format(MESSAGE_UNKNOWN_NODE_TYPE_OR_NAMESPACE, e.getMessage()), nodeContext, e));
                        this.loggedUnknownNodeTypeMessages.add(e.getMessage());
                    }
                    if (e instanceof NamespaceExceptionInNodeName) {
                        NameParser.parse((String)nodeName, (NamespaceResolver)new OnDemandRegisterNamespaceResolverWrapper((NamespaceStorage)this.ntManagerProvider), (NameFactory)NameFactoryImpl.getInstance());
                        messages.addAll(this.createNewNode(nodeContext, isFolder, isImplicit, primaryType, mixinTypes));
                        break block8;
                    }
                    this.currentNodeTypeMetaData = parentNode.addUnknownChildNode(this.ntManagerProvider.getNameResolver(), nodeContext, nodeName);
                }
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Could not create node type information for path '" + nodePath + "': " + e.getMessage(), e);
            }
        }
        return messages;
    }

    @Nullable
    private Collection<ValidationMessage> finalizeValidationForSiblings(NodeContext nodeContext) {
        String parentNodePath = Text.getRelativeParent((String)nodeContext.getNodePath(), (int)1);
        String nodeName = Text.getName((String)nodeContext.getNodePath());
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        Optional<JcrNodeTypeMetaData> parentNode = this.getNode(parentNodePath);
        if (!parentNode.isPresent()) {
            throw new IllegalArgumentException("Could not find parent node definition at " + parentNodePath);
        }
        String path = parentNodePath + "/" + nodeName;
        for (JcrNodeTypeMetaData jcrNodeTypeMetaData : parentNode.get().getChildren()) {
            try {
                if (jcrNodeTypeMetaData.getQualifiedPath(this.ntManagerProvider.getNamePathResolver()).equals(path)) continue;
                for (JcrNodeTypeMetaData jcrNodeTypeMetaData2 : jcrNodeTypeMetaData.getChildren()) {
                    messages.addAll(this.finalizeValidationForSubtree(jcrNodeTypeMetaData2, nodeContext));
                }
            }
            catch (NamespaceException e) {
                throw new IllegalStateException("Can not print qualified path for " + path, e);
            }
        }
        return messages;
    }

    @Nullable
    private Collection<ValidationMessage> finalizeValidationForSubtree(JcrNodeTypeMetaData node, NodeContext nodeContext) throws NamespaceException {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        messages.add(new ValidationMessage(ValidationMessageSeverity.DEBUG, "Finalize validation for subtree at " + nodeContext));
        for (JcrNodeTypeMetaData jcrNodeTypeMetaData : node.getChildren()) {
            messages.addAll(this.finalizeValidationForSubtree(jcrNodeTypeMetaData, nodeContext));
            messages.addAll(jcrNodeTypeMetaData.finalizeValidation(this.ntManagerProvider.getNamePathResolver(), this.ntManagerProvider.getNodeTypeDefinitionProvider(), this.ntManagerProvider.getItemDefinitionProvider(), this.defaultSeverity, this.severityForDefaultNodeTypeViolations, this.filter));
        }
        return messages;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validateJcrPath(@NotNull NodeContext nodeContext, boolean isFolder, boolean isDocViewXml) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        boolean isImplicit = this.isImplicit(nodeContext.getNodePath());
        if (isFolder) {
            messages.addAll(this.getOrCreateNewNode(nodeContext, isFolder, isImplicit, true, "nt:folder", new String[0]));
            if (!nodeContext.getNodePath().equals("/")) {
                messages.addAll(this.finalizeValidationForSiblings(nodeContext));
            }
        } else if (!isDocViewXml) {
            String fileName = nodeContext.getFilePath().getFileName().toString();
            if (fileName.endsWith(".binary")) {
                messages.addAll(this.getOrCreateNewNode(nodeContext, isFolder, isImplicit, true, "nt:folder", new String[0]));
                String propertyName = fileName.substring(0, fileName.length() - ".binary".length());
                messages.addAll(this.addProperty(nodeContext, propertyName, false, DUMMY_BINARY_VALUE));
            } else {
                messages.addAll(this.getOrCreateNewNode(nodeContext, isFolder, isImplicit, true, "nt:file", new String[0]));
                if (this.currentNodeTypeMetaData.getPrimaryNodeType().equals(NameConstants.NT_FILE)) {
                    nodeContext = new NodeContextImpl(nodeContext.getNodePath() + "/" + "jcr:content", nodeContext.getFilePath(), nodeContext.getBasePath());
                    messages.addAll(this.getOrCreateNewNode(nodeContext, isFolder, this.isImplicit(nodeContext.getNodePath()), true, "nt:resource", new String[0]));
                }
                messages.addAll(this.addProperty(nodeContext, "jcr:data", false, DUMMY_BINARY_VALUE));
                messages.addAll(this.addProperty(nodeContext, "jcr:mimeType", false, DUMMY_STRING_VALUE));
                messages.addAll(this.addProperty(nodeContext, "jcr:lastModified", false, DUMMY_DATE_VALUE));
            }
        }
        return messages;
    }

    static String joinAsQualifiedJcrName(NameResolver nameResolver, Name[] names) throws NamespaceException {
        StringBuilder types = new StringBuilder();
        String delimiter = "";
        for (Name name : names) {
            types.append(delimiter).append(nameResolver.getJCRName(name));
            delimiter = ", ";
        }
        return types.toString();
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> done() {
        try {
            return this.finalizeValidationForSubtree(this.getNode("/").orElseThrow(() -> new IllegalStateException("Cannot get root node")), new NodeContextImpl("/", Paths.get("/", new String[0]), Paths.get("/", new String[0])));
        }
        catch (NamespaceException e) {
            throw new IllegalStateException("Can not print qualified path", e);
        }
    }
}

