/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.api.ReferenceBinary;
import org.apache.jackrabbit.commons.jackrabbit.SimpleReferenceBinary;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.util.XMLChar;
import org.apache.jackrabbit.value.ValueHelper;
import org.apache.jackrabbit.vault.util.ValueComparator;
import org.jetbrains.annotations.NotNull;

public class DocViewProperty2 {
    public static final String BINARY_REF = "BinaryRef";
    private final Name name;
    private final List<String> values;
    private final boolean isMultiValue;
    private final int type;
    private final boolean isReferenceProperty;
    private static final Set<Name> UNAMBIGUOUS = new HashSet<Name>();

    @NotNull
    public static DocViewProperty2 fromValues(@NotNull Name name, @NotNull Value[] values, int type, boolean isMulti, boolean sort, boolean useBinaryReferences) throws RepositoryException {
        ArrayList<String> strValues = new ArrayList<String>();
        if (isMulti && sort) {
            Arrays.sort(values, ValueComparator.getInstance());
        }
        for (Value value : values) {
            strValues.add(DocViewProperty2.serializeValue(value, useBinaryReferences));
        }
        Boolean isBinaryRef = null;
        if (type == 2) {
            for (String strValue : strValues) {
                boolean isCurrentValueBinaryRef;
                boolean bl = isCurrentValueBinaryRef = !strValue.isEmpty();
                if (isBinaryRef == null) {
                    isBinaryRef = isCurrentValueBinaryRef;
                    continue;
                }
                if (isBinaryRef == isCurrentValueBinaryRef) continue;
                throw new ValueFormatException("Mixed binary references and regular binary values in the same multi-value property is not supported");
            }
        }
        if (isBinaryRef == null) {
            isBinaryRef = false;
        }
        return new DocViewProperty2(name, strValues, isMulti, type, isBinaryRef);
    }

    @NotNull
    public static DocViewProperty2 fromProperty(@NotNull Property prop, boolean sort, boolean useBinaryReferences) throws RepositoryException {
        boolean isMultiValue = prop.getDefinition().isMultiple();
        Value[] values = isMultiValue ? prop.getValues() : new Value[]{prop.getValue()};
        DefaultNamePathResolver nameResolver = new DefaultNamePathResolver(prop.getSession());
        return DocViewProperty2.fromValues(nameResolver.getQName(prop.getName()), values, prop.getType(), isMultiValue, sort, useBinaryReferences);
    }

    static String serializeValue(Value value, boolean useBinaryReferences) throws RepositoryException {
        String strValue = null;
        if (value.getType() == 2) {
            Binary bin;
            if (useBinaryReferences && (bin = value.getBinary()) instanceof ReferenceBinary) {
                strValue = ((ReferenceBinary)bin).getReference();
            }
            if (strValue == null) {
                strValue = "";
            }
        } else {
            strValue = ValueHelper.serialize((Value)value, (boolean)false);
        }
        return strValue;
    }

    public DocViewProperty2(@NotNull Name name, @NotNull String value, int type) {
        this(name, Collections.singletonList(value), false, type, false);
    }

    public DocViewProperty2(@NotNull Name name, @NotNull String value) {
        this(name, Collections.singletonList(value), false, 0, false);
    }

    public DocViewProperty2(@NotNull Name name, @NotNull List<String> values, int type) {
        this(name, values, true, type, false);
    }

    public DocViewProperty2(@NotNull Name name, @NotNull List<String> values) {
        this(name, values, true, 0, false);
    }

    protected DocViewProperty2(@NotNull Name name, @NotNull List<String> values, boolean isMultiValue, int type, boolean isRef) {
        this.name = name;
        this.values = Collections.unmodifiableList(values);
        this.isMultiValue = isMultiValue;
        if (type == 0 && (NameConstants.JCR_PRIMARYTYPE.equals(name) || NameConstants.JCR_MIXINTYPES.equals(name))) {
            type = 7;
        }
        this.type = type;
        if (!isMultiValue && values.size() != 1) {
            throw new IllegalArgumentException("Single value property needs exactly 1 value.");
        }
        this.isReferenceProperty = isRef;
    }

    @NotNull
    public static DocViewProperty2 parse(String name, String value, NameResolver nameResolver) throws IllegalNameException, NamespaceException {
        return DocViewProperty2.parse(nameResolver.getQName(name), value);
    }

    @NotNull
    public static DocViewProperty2 parse(Name name, String value) throws IllegalNameException, NamespaceException {
        boolean isMulti = false;
        boolean isBinaryRef = false;
        int type = 0;
        int pos = 0;
        int state = 98;
        List<String> vals = null;
        StringBuilder tmp = new StringBuilder();
        int unicode = 0;
        int unicodePos = 0;
        while (pos < value.length()) {
            char c = value.charAt(pos++);
            switch (state) {
                case 98: {
                    if (c == '{') {
                        state = 116;
                        break;
                    }
                    if (c == '[') {
                        isMulti = true;
                        state = 118;
                        break;
                    }
                    if (c == '\\') {
                        state = 101;
                        break;
                    }
                    tmp.append(c);
                    state = 118;
                    break;
                }
                case 97: {
                    if (c == '[') {
                        isMulti = true;
                        state = 118;
                        break;
                    }
                    if (c == '\\') {
                        state = 101;
                        break;
                    }
                    tmp.append(c);
                    state = 118;
                    break;
                }
                case 116: {
                    if (c == '}') {
                        if (BINARY_REF.equals(tmp.toString())) {
                            type = 2;
                            isBinaryRef = true;
                        } else {
                            type = PropertyType.valueFromName((String)tmp.toString());
                        }
                        tmp.setLength(0);
                        state = 97;
                        break;
                    }
                    tmp.append(c);
                    break;
                }
                case 118: {
                    if (c == '\\') {
                        state = 101;
                        break;
                    }
                    if (c == ',' && isMulti) {
                        if (vals == null) {
                            vals = new LinkedList<String>();
                        }
                        vals.add(tmp.toString());
                        tmp.setLength(0);
                        break;
                    }
                    if (c == ']' && isMulti && pos == value.length()) {
                        if (tmp.length() <= 0 && vals == null) break;
                        if (vals == null) {
                            vals = new LinkedList();
                        }
                        vals.add(tmp.toString());
                        tmp.setLength(0);
                        break;
                    }
                    tmp.append(c);
                    break;
                }
                case 101: {
                    if (c == 'u') {
                        state = 117;
                        unicode = 0;
                        unicodePos = 0;
                        break;
                    }
                    if (c == '0') {
                        state = 118;
                        if (vals != null) break;
                        vals = new LinkedList();
                        break;
                    }
                    state = 118;
                    tmp.append(c);
                    break;
                }
                case 117: {
                    unicode = (unicode << 4) + Character.digit(c, 16);
                    if (++unicodePos != 4) break;
                    tmp.appendCodePoint(unicode);
                    state = 118;
                }
            }
        }
        if (isMulti) {
            if (tmp.length() > 0) {
                if (vals == null) {
                    vals = new LinkedList<String>();
                }
                vals.add(tmp.toString());
            }
            if (vals == null) {
                vals = Collections.emptyList();
            }
        } else {
            vals = Collections.singletonList(tmp.toString());
        }
        return new DocViewProperty2(name, vals, isMulti, type, isBinaryRef);
    }

    @NotNull
    public static String format(@NotNull Property prop) throws RepositoryException {
        return DocViewProperty2.format(prop, false, false);
    }

    @NotNull
    public static String format(@NotNull Property prop, boolean sort, boolean useBinaryReferences) throws RepositoryException {
        return DocViewProperty2.fromProperty(prop, sort, useBinaryReferences).formatValue();
    }

    @NotNull
    public String formatValue() {
        StringBuilder attrValue = new StringBuilder();
        if (DocViewProperty2.isAmbiguous(this.type, this.name)) {
            String strType = this.isReferenceProperty ? BINARY_REF : PropertyType.nameFromValue((int)this.type);
            attrValue.append('{').append(strType).append('}');
        }
        if (this.isMultiValue) {
            attrValue.append('[');
        }
        block3: for (int i = 0; i < this.values.size(); ++i) {
            String value = this.values.get(i);
            if (this.values.size() == 1 && value.length() == 0) {
                attrValue.append("\\0");
                continue;
            }
            if (i > 0) {
                attrValue.append(',');
            }
            switch (this.type) {
                case 1: 
                case 7: 
                case 8: {
                    attrValue.append(DocViewProperty2.escape(value, this.isMultiValue));
                    continue block3;
                }
                default: {
                    attrValue.append(value);
                }
            }
        }
        if (this.isMultiValue) {
            attrValue.append(']');
        }
        return attrValue.toString();
    }

    @Deprecated
    protected static void escape(StringBuffer buf, String value, boolean isMultiValue) {
        buf.append(DocViewProperty2.escape(value, isMultiValue));
    }

    protected static String escape(String value, boolean isMultiValue) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                buf.append("\\\\");
                continue;
            }
            if (c == ',' && isMultiValue) {
                buf.append("\\,");
                continue;
            }
            if (!(i != 0 || isMultiValue || c != '[' && c != '{')) {
                buf.append('\\').append(c);
                continue;
            }
            if (XMLChar.isInvalid((int)c)) {
                buf.append("\\u");
                buf.append(Text.hexTable[c >> 12 & 0xF]);
                buf.append(Text.hexTable[c >> 8 & 0xF]);
                buf.append(Text.hexTable[c >> 4 & 0xF]);
                buf.append(Text.hexTable[c & 0xF]);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static boolean isAmbiguous(int type, Name name) {
        return type != 1 && !UNAMBIGUOUS.contains(name);
    }

    public boolean apply(@NotNull Node node) throws RepositoryException {
        Value v;
        int propType;
        Property prop;
        Property property = prop = node.hasProperty(this.name.toString()) ? node.getProperty(this.name.toString()) : null;
        if (prop != null && this.isMultiValue != prop.getDefinition().isMultiple()) {
            prop.remove();
            prop = null;
        }
        if (prop != null && (propType = prop.getType()) != this.type && (propType != 1 || this.type != 0)) {
            prop = null;
        }
        if (this.isMultiValue) {
            Value[] vs;
            Value[] valueArray = vs = prop == null ? new Value[]{} : prop.getValues();
            if (this.type == 2) {
                return this.applyBinary(node, vs);
            }
            if (vs != null && vs.length == this.values.size()) {
                boolean modified = false;
                for (int i = 0; i < vs.length; ++i) {
                    if (vs[i].getString().equals(this.values.get(i))) continue;
                    modified = true;
                }
                if (!modified) {
                    return false;
                }
            }
            if (this.type == 0) {
                node.setProperty(this.name.toString(), this.values.toArray(new String[0]));
            } else {
                node.setProperty(this.name.toString(), this.values.toArray(new String[0]), this.type);
            }
            return true;
        }
        Value value = v = prop == null ? null : prop.getValue();
        if (this.type == 2) {
            return this.applyBinary(node, v);
        }
        if (v == null || !v.getString().equals(this.values.get(0))) {
            try {
                if (this.type == 0) {
                    node.setProperty(this.name.toString(), this.values.get(0));
                } else {
                    node.setProperty(this.name.toString(), this.values.get(0), this.type);
                }
            }
            catch (ValueFormatException e) {
                node.setProperty(this.name.toString(), this.values.get(0), 1);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyBinary(@NotNull Node node, Value ... existingValues) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        ArrayList<Value> binaryValues = new ArrayList<Value>(this.values.size());
        if (!this.isReferenceProperty) {
            for (String value : this.values) {
                if (value.isEmpty()) continue;
                throw new InvalidSerializedDataException("Inline binaries are only supported as binary references, but is " + value);
            }
            return false;
        }
        try {
            boolean bl;
            boolean modified = false;
            for (int n = 0; n < this.values.size(); ++n) {
                String value = this.values.get(n);
                SimpleReferenceBinary ref = new SimpleReferenceBinary(value);
                Value binaryValue = node.getSession().getValueFactory().createValue((Binary)ref);
                binaryValues.add(binaryValue);
                if (!modified && existingValues != null && n < existingValues.length && existingValues[n] != null) {
                    Binary existingBinary = existingValues[0].getBinary();
                    if (existingBinary.equals(binaryValue.getBinary())) continue;
                    modified = true;
                    continue;
                }
                modified = true;
            }
            if (!modified) {
                bl = false;
                return bl;
            }
            if (this.isMultiValue) {
                node.setProperty(this.name.toString(), binaryValues.toArray(new Value[0]));
            } else {
                node.setProperty(this.name.toString(), (Value)binaryValues.get(0));
            }
            bl = true;
            return bl;
        }
        finally {
            for (Value value : binaryValues) {
                value.getBinary().dispose();
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isMultiValue ? 1231 : 1237);
        result = 31 * result + (this.isReferenceProperty ? 1231 : 1237);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type;
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocViewProperty2 other = (DocViewProperty2)obj;
        if (this.isMultiValue != other.isMultiValue) {
            return false;
        }
        if (this.isReferenceProperty != other.isReferenceProperty) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.values.equals(other.values);
    }

    public String toString() {
        return "DocViewProperty2 [name=" + this.name + ", values=" + String.join((CharSequence)",", this.values) + ", isMultiValue=" + this.isMultiValue + ", type=" + PropertyType.nameFromValue((int)this.type) + ", isReferenceProperty=" + this.isReferenceProperty + "]";
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    public boolean isMultiValue() {
        return this.isMultiValue;
    }

    public boolean isReferenceProperty() {
        return this.isReferenceProperty;
    }

    public int getType() {
        return this.type;
    }

    @NotNull
    public Optional<String> getStringValue() {
        if (!this.values.isEmpty()) {
            return Optional.of(this.values.get(0));
        }
        return Optional.empty();
    }

    @NotNull
    public List<String> getStringValues() {
        return this.values;
    }

    static {
        UNAMBIGUOUS.add(NameConstants.JCR_PRIMARYTYPE);
        UNAMBIGUOUS.add(NameConstants.JCR_MIXINTYPES);
    }
}

