/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.xmlbuffer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XMLNode {
    private static final String FORMAT_SINGLE_VALUE = "%s";
    private static final String FORMAT_SINGLE_VALUE_TYPED = "{%s}%s";
    private static final String FORMAT_MULTI_VALUE = "[%s]";
    private static final String FORMAT_MULTI_VALUE_TYPED = "{%s}[%s]";
    private final String basePath;
    private final String xmlElementName;
    private final String jcrNodeName;
    private final String primaryNodeType;
    private final String[] mixinNodeTypes;
    private final VaultPackageAssembler packageAssembler;
    private final Map<String, String> vltXmlParsedProperties = new HashMap<String, String>();
    private final Map<String, XMLNode> children = new LinkedHashMap<String, XMLNode>();

    public XMLNode(@NotNull VaultPackageAssembler packageAssembler, @NotNull String basePath, @NotNull String xmlElementName, @Nullable String jcrNodeName, @NotNull String primaryNodeType, @Nullable String[] mixinNodeTypes) {
        this.packageAssembler = packageAssembler;
        this.basePath = basePath;
        this.xmlElementName = xmlElementName;
        this.jcrNodeName = jcrNodeName;
        this.primaryNodeType = primaryNodeType;
        this.mixinNodeTypes = mixinNodeTypes;
    }

    public void addProperty(@NotNull String name, int propertyType, @NotNull String value) {
        String propertyTypeName = PropertyType.nameFromValue((int)propertyType);
        if (propertyType > 0) {
            this.vltXmlParsedProperties.put(name, String.format(FORMAT_SINGLE_VALUE_TYPED, propertyTypeName, value));
        } else {
            this.vltXmlParsedProperties.put(name, String.format(FORMAT_SINGLE_VALUE, value));
        }
    }

    public void addProperty(@NotNull String name, int propertyType, @NotNull String[] values) {
        String propertyTypeName = PropertyType.nameFromValue((int)propertyType);
        if (propertyType > 0) {
            this.vltXmlParsedProperties.put(name, String.format(FORMAT_MULTI_VALUE_TYPED, propertyTypeName, String.join((CharSequence)",", values)));
        } else {
            this.vltXmlParsedProperties.put(name, String.format(FORMAT_MULTI_VALUE, String.join((CharSequence)",", values)));
        }
    }

    public void addChildNode(@NotNull String name, @NotNull XMLNode xmlNode) {
        this.children.put(name, xmlNode);
    }

    public void addProperty(@NotNull String name, @Nullable Object value) throws RepositoryException {
        if (value == null) {
            return;
        }
        if (value instanceof Long) {
            this.vltXmlParsedProperties.put(name, String.format(FORMAT_SINGLE_VALUE_TYPED, "Long", value.toString()));
        } else if (value instanceof Date) {
            this.vltXmlParsedProperties.put(name, String.format(FORMAT_SINGLE_VALUE_TYPED, "Date", ((Date)value).toGMTString()));
        } else if (value instanceof Calendar) {
            this.vltXmlParsedProperties.put(name, String.format(FORMAT_SINGLE_VALUE_TYPED, "Date", ((Calendar)value).getTime().toGMTString()));
        } else if (value instanceof Double) {
            this.vltXmlParsedProperties.put(name, String.format(FORMAT_SINGLE_VALUE_TYPED, "Double", value));
        } else if (value instanceof Boolean) {
            boolean theBoolValue = Boolean.parseBoolean(value.toString());
            this.vltXmlParsedProperties.put(name, String.format(FORMAT_SINGLE_VALUE_TYPED, "Boolean", theBoolValue));
        } else if (value instanceof InputStream) {
            this.vltXmlParsedProperties.put(name, "{Binary}");
            String path = "jcr_root/" + this.basePath;
            try {
                this.packageAssembler.addEntry(path, (InputStream)value);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        } else {
            this.vltXmlParsedProperties.put(name, String.format(FORMAT_SINGLE_VALUE, value));
        }
    }

    @NotNull
    public String getPath() {
        return this.basePath + "/" + this.jcrNodeName;
    }

    @NotNull
    public String getXmlElementName() {
        return this.xmlElementName;
    }

    @Nullable
    public String getJcrNodeName() {
        return this.jcrNodeName;
    }

    @NotNull
    public String getPrimaryNodeType() {
        return this.primaryNodeType;
    }

    @Nullable
    public String[] getMixinNodeTypes() {
        return this.mixinNodeTypes;
    }

    @NotNull
    public Map<String, XMLNode> getChildren() {
        return this.children;
    }

    @NotNull
    public Map<String, String> getVltXmlParsedProperties() {
        return this.vltXmlParsedProperties;
    }
}

