/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.artifacts.InputStreamArtifactWriter;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.BundleSlingInitialContentExtractContext;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.BundleSlingInitialContentExtractor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Version;

public class BundleEntryHandler
extends AbstractRegexEntryHandler {
    private static final String NAME_GROUP_ID = "groupId";
    private static final String NAME_ARTIFACT_ID = "artifactId";
    private static final String JAR_TYPE = "jar";
    private static final Pattern POM_PROPERTIES_PATTERN = Pattern.compile("META-INF/maven/[^/]+/[^/]+/pom.properties");
    private static final Pattern POM_XML_PATTERN = Pattern.compile("META-INF/maven/[^/]+/[^/]+/pom.xml");
    private boolean enforceBundlesBelowInstallFolder;
    protected ContentPackage2FeatureModelConverter.SlingInitialContentPolicy slingInitialContentPolicy;
    private BundleSlingInitialContentExtractor bundleSlingInitialContentExtractor = new BundleSlingInitialContentExtractor();

    public BundleEntryHandler() {
        super("/jcr_root/(?:apps|libs)/.+/(?<foldername>install|config)(?:\\.(?<runmode>[^/]+))?/(?:(?<startlevel>[0-9]+)/)?.+\\.jar");
    }

    void setEnforceBundlesBelowInstallFolder(boolean enforceBundlesBelowInstallFolder) {
        this.enforceBundlesBelowInstallFolder = enforceBundlesBelowInstallFolder;
    }

    public void setSlingInitialContentPolicy(@NotNull ContentPackage2FeatureModelConverter.SlingInitialContentPolicy slingInitialContentPolicy) {
        this.slingInitialContentPolicy = slingInitialContentPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(@NotNull String path, @NotNull Archive archive, @NotNull Archive.Entry entry, @NotNull ContentPackage2FeatureModelConverter converter) throws IOException, ConverterException {
        int edx;
        String bundleName;
        int idx;
        String value;
        this.logger.info("Processing bundle {}...", (Object)entry.getName());
        Matcher matcher = this.getPattern().matcher(path);
        String runMode = null;
        Integer startLevel = null;
        if (!matcher.matches()) {
            throw new IllegalStateException("Something went terribly wrong: pattern '" + this.getPattern().pattern() + "' should have matched already with path '" + path + "' but it does not, currently");
        }
        if (this.enforceBundlesBelowInstallFolder && !"install".equals(matcher.group("foldername"))) {
            throw new ConverterException("OSGi bundles are only considered if placed below a folder called 'install', but the bundle at '" + path + "' is placed outside!");
        }
        runMode = matcher.group("runmode");
        if (runMode != null) {
            this.logger.debug("Runmode {} was extracted from path {}", (Object)runMode, (Object)path);
        }
        if ((value = matcher.group("startlevel")) != null) {
            startLevel = Integer.parseInt(value);
            this.logger.debug("Start level {} was extracted from path {}", (Object)startLevel, (Object)path);
        }
        if ((idx = (bundleName = entry.getName()).lastIndexOf(47)) >= 0) {
            bundleName = bundleName.substring(idx + 1);
        }
        if ((edx = bundleName.lastIndexOf(46)) > 0) {
            bundleName = bundleName.substring(0, edx);
        }
        Path tmpBundleJar = Files.createTempFile(converter.getTempDirectory().toPath(), "extracted", bundleName + ".jar", new FileAttribute[0]);
        try {
            try (OutputStream output = Files.newOutputStream(tmpBundleJar, new OpenOption[0]);
                 InputStream input = Objects.requireNonNull(archive.openInputStream(entry));){
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
            this.processBundleInputStream(path, tmpBundleJar, bundleName, runMode, startLevel, converter);
        }
        finally {
            Files.delete(tmpBundleJar);
        }
    }

    void processBundleInputStream(@NotNull String path, @NotNull Path originalBundleFile, @NotNull String bundleName, @Nullable String runMode, @Nullable Integer startLevel, @NotNull ContentPackage2FeatureModelConverter converter) throws ConverterException, IOException {
        try (JarFile jarFile = new JarFile(originalBundleFile.toFile());){
            ArtifactId id;
            Artifact artifact;
            block20: {
                artifact = this.extractFeatureArtifact(bundleName, jarFile);
                id = artifact.getId();
                BundleSlingInitialContentExtractContext context = new BundleSlingInitialContentExtractContext(this.slingInitialContentPolicy, path, id, jarFile, converter, runMode);
                try (InputStream strippedBundleInput = this.bundleSlingInitialContentExtractor.extract(context);){
                    if (strippedBundleInput != null && this.slingInitialContentPolicy == ContentPackage2FeatureModelConverter.SlingInitialContentPolicy.EXTRACT_AND_REMOVE) {
                        id = id.changeVersion(id.getVersion() + "-" + "cp2fm-converted");
                        Objects.requireNonNull(converter.getArtifactsDeployer()).deploy(new InputStreamArtifactWriter(strippedBundleInput), runMode, id);
                        break block20;
                    }
                    try (InputStream originalBundleInput = Files.newInputStream(originalBundleFile, new OpenOption[0]);){
                        Objects.requireNonNull(converter.getArtifactsDeployer()).deploy(new InputStreamArtifactWriter(originalBundleInput), runMode, id);
                    }
                }
            }
            artifact = artifact.copy(id);
            Objects.requireNonNull(converter.getFeaturesManager()).addArtifact(runMode, artifact, startLevel);
            String exportHeader = Objects.requireNonNull(jarFile.getManifest()).getMainAttributes().getValue("Export-Package");
            if (exportHeader != null) {
                for (Clause clause : Parser.parseHeader((String)exportHeader)) {
                    converter.getFeaturesManager().addAPIRegionExport(runMode, clause.getName());
                }
            }
        }
    }

    @Nullable
    private ArtifactId extractArtifactIdFromPomProperties(@NotNull String bundleName, @NotNull JarFile jarFile, @NotNull JarEntry jarEntry) throws IOException {
        this.logger.info("Reading '{}' bundle GAV from {}...", (Object)bundleName, (Object)jarEntry.getName());
        Properties properties = new Properties();
        try (InputStream input = jarFile.getInputStream(jarEntry);){
            properties.load(input);
        }
        String groupId = properties.getProperty(NAME_GROUP_ID);
        String artifactId = properties.getProperty(NAME_ARTIFACT_ID);
        String version = properties.getProperty("version");
        if (groupId != null && artifactId != null && version != null) {
            return new ArtifactId(groupId, artifactId, version, null, null);
        }
        return null;
    }

    @Nullable
    private ArtifactId extractArtifactIdFromPom(@NotNull String bundleName, @NotNull JarFile jarFile, @NotNull JarEntry jarEntry) {
        this.logger.info("Reading '{}' bundle GAV from {}...", (Object)bundleName, (Object)jarEntry.getName());
        String path = jarEntry.getName().substring(0, jarEntry.getName().length() - "/pom.xml".length());
        String groupId = path.substring("META-INF/maven/".length(), path.lastIndexOf(47));
        String artifactId = path.substring(path.lastIndexOf(47) + 1);
        String version = null;
        if (artifactId.indexOf(45) != -1) {
            version = artifactId.substring(artifactId.indexOf(45));
            artifactId = artifactId.substring(0, artifactId.indexOf(45));
        } else if (bundleName.indexOf(45) != -1) {
            try {
                String versionString = bundleName.substring(bundleName.indexOf(45) + 1);
                if (!Version.parseVersion((String)versionString).equals((Object)Version.emptyVersion)) {
                    version = versionString;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (groupId != null && artifactId != null && version != null) {
            return new ArtifactId(groupId, artifactId, version, null, null);
        }
        return null;
    }

    @NotNull
    private ArtifactId extractArtifactIdFromSymbolicName(@NotNull JarFile jarFile) throws IOException {
        String groupId = StringUtils.substringBefore((String)BundleEntryHandler.getCheckedProperty(jarFile.getManifest(), "Bundle-SymbolicName"), (String)";");
        String artifactId = null;
        if ((groupId = groupId.replace(' ', '_').replace(':', '_').replace('/', '_').replace('\\', '_')).indexOf(46) != -1) {
            artifactId = groupId.substring(groupId.lastIndexOf(46) + 1);
            groupId = groupId.substring(0, groupId.lastIndexOf(46));
        }
        if (artifactId == null || artifactId.isEmpty()) {
            artifactId = groupId;
        }
        Version osgiVersion = Version.parseVersion((String)BundleEntryHandler.getCheckedProperty(jarFile.getManifest(), "Bundle-Version"));
        String version = osgiVersion.getMajor() + "." + osgiVersion.getMinor() + "." + osgiVersion.getMicro() + (osgiVersion.getQualifier().isEmpty() ? "" : "-" + osgiVersion.getQualifier());
        return new ArtifactId(groupId, artifactId, version, null, null);
    }

    @NotNull
    protected Artifact extractFeatureArtifact(@NotNull String bundleName, @NotNull JarFile jarFile) throws IOException {
        ArtifactId resultId = null;
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            String suffix;
            String synthesized;
            JarEntry jarEntry = e.nextElement();
            if (POM_PROPERTIES_PATTERN.matcher(jarEntry.getName()).matches()) {
                resultId = this.extractArtifactIdFromPomProperties(bundleName, jarFile, jarEntry);
            } else if (POM_XML_PATTERN.matcher(jarEntry.getName()).matches()) {
                resultId = this.extractArtifactIdFromPom(bundleName, jarFile, jarEntry);
            }
            if (resultId == null || !bundleName.startsWith(synthesized = resultId.getArtifactId().concat("-").concat(resultId.getVersion())) && !bundleName.equals(resultId.getArtifactId())) continue;
            if (synthesized.length() >= bundleName.length() || (suffix = bundleName.substring(synthesized.length())).length() <= 1 || !suffix.startsWith("-")) break;
            resultId = resultId.changeClassifier(suffix.substring(1));
            this.logger.info("Inferred classifier of '{}'", (Object)resultId.toMvnId());
            break;
        }
        if (resultId == null) {
            resultId = this.extractArtifactIdFromSymbolicName(jarFile);
        }
        Artifact result = new Artifact(resultId.changeType(JAR_TYPE));
        BundleEntryHandler.setMetadataFromManifest(jarFile.getManifest(), "Bundle-Version", result, false);
        BundleEntryHandler.setMetadataFromManifest(jarFile.getManifest(), "Bundle-SymbolicName", result, true);
        return result;
    }

    private static void setMetadataFromManifest(@NotNull Manifest manifest, @NotNull String name, @NotNull Artifact artifact, boolean strip) {
        String value = manifest.getMainAttributes().getValue(name);
        if (strip) {
            value = StringUtils.substringBefore((String)value, (String)";");
        }
        if (value != null) {
            artifact.getMetadata().put(name, value);
        }
    }

    @NotNull
    private static String getCheckedProperty(@NotNull Manifest manifest, @NotNull String name) {
        String property = manifest.getMainAttributes().getValue(name);
        if (property != null) {
            property = property.trim();
        }
        return Objects.requireNonNull(property, "Jar file can not be defined as a valid OSGi bundle without specifying a valid '" + name + "' property.");
    }

    public void setBundleSlingInitialContentExtractor(BundleSlingInitialContentExtractor bundleSlingInitialContentExtractor) {
        this.bundleSlingInitialContentExtractor = bundleSlingInitialContentExtractor;
    }
}

